/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.wss;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.IThrowingSupplier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.wss4j.dom.engine.WSSConfig;

@ThreadSafe
public final class WSSSynchronizer {
    private static final Lock LOCK = new ReentrantLock();

    private WSSSynchronizer() {
    }

    public static void run(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull((Object)runnable, (String)"Runnable");
        WSSSynchronizer.call(() -> {
            runnable.run();
            return null;
        });
    }

    @Nullable
    public static <T, EX extends Exception> T call(@Nonnull IThrowingSupplier<T, EX> iThrowingSupplier) throws EX {
        ValueEnforcer.notNull(iThrowingSupplier, (String)"Supplier");
        LOCK.lock();
        try {
            Object object;
            WSSConfig.init();
            try {
                object = iThrowingSupplier.get();
            }
            catch (Throwable throwable) {
                WSSConfig.cleanUp();
                throw throwable;
            }
            WSSConfig.cleanUp();
            return (T)object;
        }
        finally {
            LOCK.unlock();
        }
    }
}

