/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.mock;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.io.resource.IReadableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;

@Immutable
public class PhiveTestFile {
    private final IReadableResource m_aResource;
    private final DVRCoordinate m_aVESID;
    private final ICommonsSet<String> m_aExpectedErrorIDs;

    public PhiveTestFile(@Nonnull IReadableResource iReadableResource, @Nonnull DVRCoordinate dVRCoordinate, @Nullable Set<String> set) {
        this.m_aResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_aVESID = (DVRCoordinate)ValueEnforcer.notNull((Object)dVRCoordinate, (String)"VESID");
        this.m_aExpectedErrorIDs = new CommonsHashSet(set);
    }

    @Nonnull
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    public DVRCoordinate getVESID() {
        return this.m_aVESID;
    }

    public boolean isGoodCase() {
        return this.m_aExpectedErrorIDs.isEmpty();
    }

    public boolean isBadCase() {
        return this.m_aExpectedErrorIDs.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllExpectedErrorIDs() {
        return (ICommonsSet)this.m_aExpectedErrorIDs.getClone();
    }

    @Nonnull
    public static PhiveTestFile createGoodCase(@Nonnull IReadableResource iReadableResource, @Nonnull DVRCoordinate dVRCoordinate) {
        return new PhiveTestFile(iReadableResource, dVRCoordinate, null);
    }
}

