/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.result;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.phive.api.artefact.IValidationArtefact;
import jakarta.annotation.Nonnull;

@Immutable
public class ValidationResult {
    private final IValidationArtefact m_aValidationArtefact;
    private final IErrorList m_aErrorList;
    private final boolean m_bSkipped;
    private final long m_nDurationMS;

    public ValidationResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull IErrorList iErrorList, @Nonnegative long l) {
        this(iValidationArtefact, iErrorList, false, l);
    }

    protected ValidationResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull IErrorList iErrorList, boolean bl, @Nonnegative long l) {
        ValueEnforcer.notNull((Object)iValidationArtefact, (String)"ValidationArtefact");
        ValueEnforcer.notNull((Object)iErrorList, (String)"ErrorList");
        ValueEnforcer.isGE0((long)l, (String)"DurationMS");
        this.m_aValidationArtefact = iValidationArtefact;
        this.m_aErrorList = iErrorList;
        this.m_bSkipped = bl;
        this.m_nDurationMS = l;
    }

    @Nonnull
    public final IValidationArtefact getValidationArtefact() {
        return this.m_aValidationArtefact;
    }

    @Nonnull
    @ReturnsMutableObject
    public final IErrorList getErrorList() {
        return this.m_aErrorList;
    }

    public final boolean isSkipped() {
        return this.m_bSkipped;
    }

    @Nonnegative
    public final long getDurationMS() {
        return this.m_nDurationMS;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ValidationArtefact", (Object)this.m_aValidationArtefact).append("ErrorList", (Object)this.m_aErrorList).append("Skipped", this.m_bSkipped).append("DurationMS", this.m_nDurationMS).getToString();
    }

    @Nonnull
    public static ValidationResult createSkippedResult(@Nonnull IValidationArtefact iValidationArtefact) {
        return new ValidationResult(iValidationArtefact, (IErrorList)new ErrorList(), true, 0L);
    }
}

