/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.xml.schematron;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@ThreadSafe
public final class SchematronNamespaceBeautifier {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final MapBasedNamespaceContext NS_CTX = new MapBasedNamespaceContext();

    private SchematronNamespaceBeautifier() {
    }

    public static void addMapping(@Nonnull String string, @Nonnull String string2) {
        RW_LOCK.writeLocked(() -> NS_CTX.setMapping(string, string2));
    }

    public static void addMappings(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        if (iIterableNamespaceContext != null) {
            RW_LOCK.writeLocked(() -> NS_CTX.setMappings(iIterableNamespaceContext));
        }
    }

    @Nonnull
    public static void removeAllMappings() {
        RW_LOCK.writeLocked(() -> ((MapBasedNamespaceContext)NS_CTX).clear());
    }

    @Nullable
    public static String getMapping(@Nullable String string) {
        return (String)RW_LOCK.readLockedGet(() -> NS_CTX.getPrefix(string));
    }
}

