/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.xml.xsd;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class XSDPartialContext {
    private final XPathExpression m_aXE;
    private final Integer m_aMinNodeCount;
    private final Integer m_aMaxNodeCount;

    public XSDPartialContext(@Nonnull XPathExpression xPathExpression, @Nullable Integer n, @Nullable Integer n2) {
        ValueEnforcer.notNull((Object)xPathExpression, (String)"XPathExpression");
        this.m_aXE = xPathExpression;
        this.m_aMinNodeCount = n;
        this.m_aMaxNodeCount = n2;
    }

    @Nonnull
    public XPathExpression getXPathExpression() {
        return this.m_aXE;
    }

    public boolean hasMinNodeCount() {
        return this.m_aMinNodeCount != null;
    }

    public int getMinNodeCount() {
        return this.m_aMinNodeCount;
    }

    public boolean hasMaxNodeCount() {
        return this.m_aMaxNodeCount != null;
    }

    public int getMaxNodeCount() {
        return this.m_aMaxNodeCount;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("XPathExpression", (Object)this.m_aXE).append("MinNodeCount", (Object)this.m_aMinNodeCount).append("MaxNodeCount", (Object)this.m_aMaxNodeCount).getToString();
    }

    @Nonnull
    public static XSDPartialContext create(@Nonnull XPathExpression xPathExpression) {
        return new XSDPartialContext(xPathExpression, null, null);
    }

    @Nonnull
    public static XSDPartialContext createMandatory(@Nonnull XPathExpression xPathExpression) {
        return XSDPartialContext.create(xPathExpression, 1, 1);
    }

    @Nonnull
    public static XSDPartialContext create(@Nonnull XPathExpression xPathExpression, @Nonnegative int n, @Nonnegative int n2) {
        return new XSDPartialContext(xPathExpression, n, n2);
    }
}

