/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.rules.api;

import com.helger.annotation.concurrent.Immutable;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.EValidationType;
import com.helger.phive.api.artefact.IValidationArtefact;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.schematron.pure.SchematronResourcePure;
import com.helger.schematron.sch.SchematronResourceSCH;
import com.helger.schematron.schxslt.xslt2.SchematronResourceSchXslt_XSLT2;
import com.helger.schematron.xslt.SchematronResourceXSLT;

@Immutable
public final class PhiveRulesTestHelper {
    private PhiveRulesTestHelper() {
    }

    public static boolean isContentCorrect(IValidationExecutor<IValidationSourceXML> iValidationExecutor) {
        IValidationArtefact iValidationArtefact = iValidationExecutor.getValidationArtefact();
        IReadableResource iReadableResource = iValidationArtefact.getRuleResource();
        if (iValidationArtefact.getValidationType() == EValidationType.SCHEMATRON_PURE) {
            return new SchematronResourcePure(iReadableResource).isValidSchematron();
        }
        if (iValidationArtefact.getValidationType() == EValidationType.SCHEMATRON_SCH) {
            return new SchematronResourceSCH(iReadableResource).isValidSchematron();
        }
        if (iValidationArtefact.getValidationType() == EValidationType.SCHEMATRON_XSLT) {
            return new SchematronResourceXSLT(iReadableResource).isValidSchematron();
        }
        if (iValidationArtefact.getValidationType() == EValidationType.SCHEMATRON_SCHXSLT) {
            return new SchematronResourceSchXslt_XSLT2(iReadableResource).isValidSchematron();
        }
        return true;
    }
}

