/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.string.StringHelper;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Immutable
public final class SchematronResourceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronResourceHelper.class);
    private static final SchematronResourceHelper INSTANCE = new SchematronResourceHelper();

    private SchematronResourceHelper() {
    }

    @Nullable
    public static Node getNodeOfSource(@Nonnull Source source, @Nonnull DOMReaderSettings dOMReaderSettings) {
        ValueEnforcer.notNull((Object)source, (String)"Source");
        ValueEnforcer.notNull((Object)dOMReaderSettings, (String)"DOMReaderSettings");
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream inputStream = streamSource.getInputStream();
            if (inputStream != null) {
                Document document = DOMReader.readXMLDOM((InputStream)inputStream, (IDOMReaderSettings)dOMReaderSettings);
                if (document == null) {
                    throw new IllegalArgumentException("Failed to read source " + source + " as XML from InputStream " + inputStream);
                }
                return document;
            }
            Reader reader = streamSource.getReader();
            if (reader != null) {
                Document document = DOMReader.readXMLDOM((Reader)reader, (IDOMReaderSettings)dOMReaderSettings);
                if (document == null) {
                    throw new IllegalArgumentException("Failed to read source " + source + " as XML from Reader " + reader);
                }
                return document;
            }
            String string = streamSource.getSystemId();
            if (StringHelper.hasText((String)string)) {
                try {
                    URLResource uRLResource = new URLResource(string);
                    Document document = DOMReader.readXMLDOM((IReadableResource)uRLResource, (IDOMReaderSettings)dOMReaderSettings);
                    if (document == null) {
                        throw new IllegalArgumentException("Failed to read source " + source + " as XML from SystemID '" + string + "'");
                    }
                    return document;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Failed to read source " + source + " as XML from SystemID '" + string + "': " + malformedURLException.getMessage());
                }
            }
            LOGGER.error("StreamSource contains neither InputStream nor Reader nor SystemID - cannot handle!");
            return null;
        }
        String string = "Can only handle DOMSource and StreamSource - having " + source + " with system ID '" + source.getSystemId() + "'";
        LOGGER.error(string);
        throw new IllegalArgumentException(string);
    }
}

