/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.HttpDebugger;
import com.helger.httpclient.IHttpClientProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;

public class HttpClientManager
implements AutoCloseable {
    private CloseableHttpClient m_aHttpClient;

    public HttpClientManager() {
        this(new HttpClientFactory());
    }

    public HttpClientManager(@Nonnull IHttpClientProvider iHttpClientProvider) {
        ValueEnforcer.notNull((Object)iHttpClientProvider, (String)"HttpClientSupplier");
        this.m_aHttpClient = iHttpClientProvider.createHttpClient();
        if (this.m_aHttpClient == null) {
            throw new IllegalArgumentException("The provided HttpClient factory created an invalid (null) HttpClient!");
        }
    }

    @Override
    public void close() {
        StreamHelper.close((AutoCloseable)this.m_aHttpClient);
        this.m_aHttpClient = null;
    }

    public final boolean isClosed() {
        return this.m_aHttpClient == null;
    }

    protected final void checkIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HttpClientManager was already closed!");
        }
    }

    @Nullable
    public <T> T execute(@Nonnull HttpUriRequest httpUriRequest, @Nonnull HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws IOException {
        return this.execute((ClassicHttpRequest)httpUriRequest, (HttpContext)((HttpClientContext)null), httpClientResponseHandler);
    }

    @Nullable
    public <T> T execute(@Nonnull ClassicHttpRequest classicHttpRequest, @Nullable HttpContext httpContext, @Nonnull HttpClientResponseHandler<? extends T> httpClientResponseHandler) throws IOException {
        Object object;
        this.checkIfClosed();
        HttpDebugger.beforeRequest(classicHttpRequest, httpContext);
        Object object2 = null;
        Exception exception = null;
        try {
            object = object2 = this.m_aHttpClient.execute(classicHttpRequest, httpContext, httpClientResponseHandler);
        }
        catch (IOException | RuntimeException exception2) {
            try {
                exception = exception2;
                throw exception2;
            }
            catch (Throwable throwable) {
                HttpDebugger.afterRequest(classicHttpRequest, object2, exception);
                throw throwable;
            }
        }
        HttpDebugger.afterRequest(classicHttpRequest, object2, exception);
        return (T)object;
    }

    @Nonnull
    public static HttpClientManager create(@Nonnull HttpClientSettings httpClientSettings) {
        return new HttpClientManager(new HttpClientFactory(httpClientSettings));
    }
}

