/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.util.TimeValue;

public class HttpClientRetryStrategy
extends DefaultHttpRequestRetryStrategy {
    private final int m_nMaxRetries;
    private final TimeValue m_aRetryInterval;
    private final boolean m_bRetryAlways;

    public HttpClientRetryStrategy(@Nonnegative int n, @Nonnull TimeValue timeValue, boolean bl) {
        super(n, timeValue);
        ValueEnforcer.isGE0((int)n, (String)"MaxRetries");
        ValueEnforcer.notNull((Object)timeValue, (String)"RetryInterval");
        this.m_nMaxRetries = n;
        this.m_aRetryInterval = timeValue;
        this.m_bRetryAlways = bl;
    }

    @Nonnegative
    public final int getMaxRetries() {
        return this.m_nMaxRetries;
    }

    @Nonnull
    public final TimeValue getRetryInterval() {
        return this.m_aRetryInterval;
    }

    protected boolean handleAsIdempotent(HttpRequest httpRequest) {
        if (this.m_bRetryAlways) {
            return true;
        }
        return super.handleAsIdempotent(httpRequest);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("MaxRetries", this.m_nMaxRetries).append("RetryInterval", (Object)this.m_aRetryInterval).append("RetryAlways", this.m_bRetryAlways).getToString();
    }
}

