/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.concurrent.Immutable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class HttpDebugger {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDebugger.class);
    private static final AtomicBoolean ENABLED = new AtomicBoolean(false);

    private HttpDebugger() {
    }

    public static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void setEnabled(boolean bl) {
        ENABLED.set(bl);
    }

    public static void beforeRequest(@Nonnull ClassicHttpRequest classicHttpRequest, @Nullable HttpContext httpContext) {
        if (HttpDebugger.isEnabled()) {
            LOGGER.info("Before HTTP call: " + classicHttpRequest.toString() + (httpContext != null ? " (with special HTTP context)" : ""));
        }
    }

    public static void afterRequest(@Nonnull ClassicHttpRequest classicHttpRequest, @Nullable Object object, @Nullable Throwable throwable) {
        if (HttpDebugger.isEnabled()) {
            HttpResponseException httpResponseException = throwable instanceof HttpResponseException ? (HttpResponseException)throwable : null;
            LOGGER.info("After HTTP call: " + classicHttpRequest.getMethod() + (String)(object != null ? ". Response: " + String.valueOf(object) : ". No response") + (String)(httpResponseException != null ? ". Status: " + httpResponseException.getStatusCode() : ""), httpResponseException != null ? null : throwable);
        }
    }
}

