/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.Nonnegative;
import com.helger.base.string.StringHelper;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.httpclient.IHttpProxySettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.util.Timeout;

public interface IHttpClientSettings {
    public boolean isUseDNSClientCache();

    @Nullable
    public SSLContext getSSLContext();

    @Nullable
    public HostnameVerifier getHostnameVerifier();

    @Nullable
    public ITLSConfigurationMode getTLSConfigurationMode();

    @Nonnull
    public IHttpProxySettings getGeneralProxy();

    @Nonnull
    public IHttpProxySettings getHttpProxy();

    @Nonnull
    public IHttpProxySettings getHttpsProxy();

    @Nonnegative
    public int getRetryCount();

    default public boolean hasRetries() {
        return this.getRetryCount() > 0;
    }

    @Nonnull
    public Duration getRetryInterval();

    public boolean isRetryAlways();

    @Nonnull
    public Timeout getConnectionRequestTimeout();

    @Nonnull
    public Timeout getConnectTimeout();

    @Nonnull
    public Timeout getResponseTimeout();

    @Nullable
    public String getUserAgent();

    default public boolean hasUserAgent() {
        return StringHelper.isNotEmpty((String)this.getUserAgent());
    }

    public boolean isFollowRedirects();

    public boolean isUseKeepAlive();

    public boolean isProtocolUpgradeEnabled();
}

