/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.security;

import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import javax.net.ssl.SSLParameters;
import org.apache.hc.core5.ssl.PrivateKeyDetails;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyStrategyFromAliasCaseInsensitive
implements PrivateKeyStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyStrategyFromAliasCaseInsensitive.class);
    private final String m_sExpectedAlias;
    private boolean m_bWarnOnCaseDifference = false;

    public PrivateKeyStrategyFromAliasCaseInsensitive(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"ExpectedAlias");
        this.m_sExpectedAlias = string;
    }

    @Nonnull
    public final String getExpectedAlias() {
        return this.m_sExpectedAlias;
    }

    public final boolean isWarnOnCaseDifference() {
        return this.m_bWarnOnCaseDifference;
    }

    public final void setWarnOnCaseDifference(boolean bl) {
        this.m_bWarnOnCaseDifference = bl;
    }

    @Nullable
    public String chooseAlias(@Nonnull Map<String, PrivateKeyDetails> map, @Nullable SSLParameters sSLParameters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("chooseAlias(" + String.valueOf(map) + ", " + String.valueOf(sSLParameters) + ")");
        }
        for (String string : map.keySet()) {
            if (!string.equalsIgnoreCase(this.m_sExpectedAlias)) continue;
            if (string.equals(this.m_sExpectedAlias)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("  Chose alias '" + string + "'");
                }
            } else if (this.m_bWarnOnCaseDifference) {
                LOGGER.warn("Chose the keystore alias '" + string + "' but the configured alias '" + this.m_sExpectedAlias + "' has a different casing. It is recommended to adopt the expected alias accordingly.");
            }
            return string;
        }
        LOGGER.warn("Found no certificate alias matching '" + this.m_sExpectedAlias + "' in the provided aliases " + String.valueOf(map.keySet()));
        return null;
    }
}

