/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.port;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.network.port.ENetworkProtocol;
import com.helger.network.port.INetworkPort;
import com.helger.network.port.NetworkPortHelper;
import jakarta.annotation.Nonnull;

@Immutable
public class NetworkPort
implements INetworkPort {
    private final int m_nPort;
    private final ENetworkProtocol m_eProtocol;
    private final String m_sName;
    private final String m_sDescription;

    public NetworkPort(@Nonnegative int n, @Nonnull ENetworkProtocol eNetworkProtocol, @Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.isTrue((boolean)NetworkPortHelper.isValidPort(n), () -> "Port is illegal: " + n);
        this.m_nPort = n;
        this.m_eProtocol = (ENetworkProtocol)((Object)ValueEnforcer.notNull((Object)((Object)eNetworkProtocol), (String)"Protocol"));
        this.m_sName = (String)ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_sDescription = (String)ValueEnforcer.notNull((Object)string2, (String)"Description");
    }

    @Override
    @Nonnegative
    public int getPort() {
        return this.m_nPort;
    }

    @Override
    @Nonnull
    public ENetworkProtocol getProtocol() {
        return this.m_eProtocol;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.m_sDescription;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        NetworkPort networkPort = (NetworkPort)object;
        return this.m_nPort == networkPort.m_nPort && this.m_eProtocol.equals((Object)networkPort.m_eProtocol) && this.m_sName.equals(networkPort.m_sName) && this.m_sDescription.equals(networkPort.m_sDescription);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nPort).append((Object)this.m_eProtocol).append((Object)this.m_sName).append((Object)this.m_sDescription).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("port", this.m_nPort).append("protocol", (Enum)this.m_eProtocol).append("name", (Object)this.m_sName).append("description", (Object)this.m_sDescription).getToString();
    }
}

