/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.base.id.IHasID;
import com.helger.base.string.StringParser;
import com.helger.base.system.SystemProperties;
import com.helger.url.protocol.IURLProtocol;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public interface IProxySettingsPerProtocol
extends IHasID<String> {
    @Nonnull
    public IURLProtocol getURLProtocol();

    @Nonnegative
    public int getDefaultPort();

    @Nonnull
    default public String getPropertyNameProxyHost() {
        return (String)this.getID() + ".proxyHost";
    }

    @Nullable
    default public String getProxyHost() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyHost());
    }

    @Nonnull
    default public String getPropertyNameProxyPort() {
        return (String)this.getID() + ".proxyPort";
    }

    @CheckForSigned
    default public int getProxyPort() {
        return StringParser.parseInt((String)SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyPort()), (int)-1);
    }

    @Nonnull
    default public String getPropertyNameProxyUserName() {
        return (String)this.getID() + ".proxyUser";
    }

    @Nullable
    default public String getProxyUserName() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyUserName());
    }

    @Nonnull
    default public String getPropertyNameProxyPassword() {
        return (String)this.getID() + ".proxyPassword";
    }

    @Nullable
    default public String getProxyPassword() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyPassword());
    }

    @Nonnull
    default public String getPropertyNameNoProxyHosts() {
        return (String)this.getID() + ".noProxyHosts";
    }

    @Nullable
    default public String getNoProxyHosts() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameNoProxyHosts());
    }
}

