/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringParser;
import com.helger.base.system.SystemProperties;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.network.proxy.config.HttpProxyConfig;
import com.helger.network.proxy.config.IProxyConfig;
import com.helger.network.proxy.config.SocksProxyConfig;
import jakarta.annotation.Nullable;
import java.net.Proxy;

@Immutable
public class UseSystemProxyConfig
implements IProxyConfig {
    public static final String SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";

    public boolean isUseSystemProxies() {
        return StringParser.parseBool((String)SystemProperties.getPropertyValueOrNull((String)SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES), (boolean)false);
    }

    @Override
    public void activateGlobally() {
        UseSystemProxyConfig.activateGloballyStatic();
    }

    public static void activateGloballyStatic() {
        HttpProxyConfig.deactivateGlobally();
        SocksProxyConfig.deactivateGlobally();
        SystemProperties.setPropertyValue((String)SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES, (String)Boolean.TRUE.toString());
    }

    public static void deactivateGlobally() {
        SystemProperties.removePropertyValue((String)SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES);
    }

    @Override
    @Nullable
    public Proxy getAsProxy() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

