/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.SecurityDescriptor;
import com.hierynomus.msdtyp.SecurityInformation;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.FileSystemInformationClass;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileDirectoryQueryableInformation;
import com.hierynomus.msfscc.fileinformation.FileDispositionInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.msfscc.fileinformation.FileInformation;
import com.hierynomus.msfscc.fileinformation.FileInformationFactory;
import com.hierynomus.msfscc.fileinformation.FileQueryableInformation;
import com.hierynomus.msfscc.fileinformation.FileSettableInformation;
import com.hierynomus.msfscc.fileinformation.ShareInfo;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryInfoRequest;
import com.hierynomus.mssmb2.messages.SMB2SetInfoRequest;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.protocol.transport.TransportException;
import com.hierynomus.smb.SMBBuffer;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.share.Directory;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.share.Share;
import com.hierynomus.smbj.share.TreeConnect;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class DiskShare
extends Share {
    public DiskShare(SmbPath smbPath, TreeConnect treeConnect) {
        super(smbPath, treeConnect);
    }

    public DiskEntry open(String path, Set<AccessMask> accessMask, Set<FileAttributes> attributes, Set<SMB2ShareAccess> shareAccesses, SMB2CreateDisposition createDisposition, Set<SMB2CreateOptions> createOptions) {
        SMB2CreateResponse response = this.createFile(path, null, accessMask, attributes, shareAccesses, createDisposition, createOptions);
        return this.getDiskEntry(path, response);
    }

    protected DiskEntry getDiskEntry(String path, SMB2CreateResponse response) {
        if (response.getFileAttributes().contains(FileAttributes.FILE_ATTRIBUTE_DIRECTORY)) {
            return new Directory(response.getFileId(), this, path);
        }
        return new File(response.getFileId(), this, path);
    }

    public Directory openDirectory(String path, Set<AccessMask> accessMask, Set<FileAttributes> attributes, Set<SMB2ShareAccess> shareAccesses, SMB2CreateDisposition createDisposition, Set<SMB2CreateOptions> createOptions) {
        EnumSet<SMB2CreateOptions> actualCreateOptions = createOptions != null ? EnumSet.copyOf(createOptions) : EnumSet.noneOf(SMB2CreateOptions.class);
        actualCreateOptions.add(SMB2CreateOptions.FILE_DIRECTORY_FILE);
        actualCreateOptions.remove(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE);
        EnumSet<FileAttributes> actualAttributes = attributes != null ? EnumSet.copyOf(attributes) : EnumSet.noneOf(FileAttributes.class);
        actualAttributes.add(FileAttributes.FILE_ATTRIBUTE_DIRECTORY);
        return (Directory)this.open(path, accessMask, actualAttributes, shareAccesses, createDisposition, actualCreateOptions);
    }

    public File openFile(String path, Set<AccessMask> accessMask, Set<FileAttributes> attributes, Set<SMB2ShareAccess> shareAccesses, SMB2CreateDisposition createDisposition, Set<SMB2CreateOptions> createOptions) {
        EnumSet<SMB2CreateOptions> actualCreateOptions = createOptions != null ? EnumSet.copyOf(createOptions) : EnumSet.noneOf(SMB2CreateOptions.class);
        actualCreateOptions.add(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE);
        actualCreateOptions.remove(SMB2CreateOptions.FILE_DIRECTORY_FILE);
        EnumSet<FileAttributes> actualAttributes = attributes != null ? EnumSet.copyOf(attributes) : EnumSet.noneOf(FileAttributes.class);
        actualAttributes.remove(FileAttributes.FILE_ATTRIBUTE_DIRECTORY);
        return (File)this.open(path, accessMask, actualAttributes, shareAccesses, createDisposition, actualCreateOptions);
    }

    public boolean fileExists(String path) throws SMBApiException {
        return this.exists(path, EnumSet.of(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE));
    }

    public boolean folderExists(String path) throws SMBApiException {
        return this.exists(path, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exists(String path, EnumSet<SMB2CreateOptions> createOptions) throws SMBApiException {
        try (DiskEntry ignored = this.open(path, EnumSet.of(AccessMask.FILE_READ_ATTRIBUTES), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, createOptions);){
            boolean bl = true;
            return bl;
        }
        catch (SMBApiException sae) {
            if (sae.getStatus() == NtStatus.STATUS_OBJECT_NAME_NOT_FOUND) return false;
            if (sae.getStatus() != NtStatus.STATUS_OBJECT_PATH_NOT_FOUND) throw sae;
            return false;
        }
    }

    public List<FileIdBothDirectoryInformation> list(String path) throws SMBApiException {
        return this.list(path, FileIdBothDirectoryInformation.class, null);
    }

    public List<FileIdBothDirectoryInformation> list(String path, String searchPattern) throws SMBApiException {
        return this.list(path, FileIdBothDirectoryInformation.class, searchPattern);
    }

    public <I extends FileDirectoryQueryableInformation> List<I> list(String path, Class<I> informationClass) {
        return this.list(path, informationClass, null);
    }

    public <I extends FileDirectoryQueryableInformation> List<I> list(String path, Class<I> informationClass, String searchPattern) {
        try (Directory d = this.openDirectory(path, EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            List<I> list = d.list(informationClass, searchPattern);
            return list;
        }
    }

    public void mkdir(String path) throws SMBApiException {
        Directory fileHandle = this.openDirectory(path, EnumSet.of(AccessMask.FILE_LIST_DIRECTORY, AccessMask.FILE_ADD_SUBDIRECTORY), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_DIRECTORY), SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_CREATE, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
        fileHandle.close();
    }

    public FileAllInformation getFileInformation(String path) throws SMBApiException {
        return this.getFileInformation(path, FileAllInformation.class);
    }

    public <F extends FileQueryableInformation> F getFileInformation(String path, Class<F> informationClass) throws SMBApiException {
        try (DiskEntry e = this.open(path, EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            F f = e.getFileInformation(informationClass);
            return f;
        }
    }

    public FileAllInformation getFileInformation(SMB2FileId fileId) throws SMBApiException, TransportException {
        return this.getFileInformation(fileId, FileAllInformation.class);
    }

    public <F extends FileQueryableInformation> F getFileInformation(SMB2FileId fileId, Class<F> informationClass) throws SMBApiException {
        FileInformation.Decoder<F> decoder = FileInformationFactory.getDecoder(informationClass);
        byte[] outputBuffer = this.queryInfo(fileId, SMB2QueryInfoRequest.SMB2QueryInfoType.SMB2_0_INFO_FILE, null, decoder.getInformationClass(), null).getOutputBuffer();
        try {
            return (F)((FileQueryableInformation)decoder.read(new Buffer.PlainBuffer(outputBuffer, Endian.LE)));
        }
        catch (Buffer.BufferException e) {
            throw new SMBRuntimeException(e);
        }
    }

    public <F extends FileSettableInformation> void setFileInformation(SMB2FileId fileId, F information) {
        SMBBuffer buffer = new SMBBuffer();
        FileInformation.Encoder<F> encoder = FileInformationFactory.getEncoder(information);
        encoder.write(information, buffer);
        this.setInfo(fileId, SMB2SetInfoRequest.SMB2InfoType.SMB2_0_INFO_FILE, null, encoder.getInformationClass(), buffer.getCompactData());
    }

    public <F extends FileSettableInformation> void setFileInformation(String path, F information) throws SMBApiException {
        try (DiskEntry e = this.open(path, EnumSet.of(AccessMask.GENERIC_WRITE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            e.setFileInformation(information);
        }
    }

    public ShareInfo getShareInformation() throws SMBApiException {
        Throwable throwable = null;
        try (Directory directory = this.openDirectory("", EnumSet.of(AccessMask.FILE_READ_ATTRIBUTES), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            byte[] outputBuffer = this.queryInfo(directory.getFileId(), SMB2QueryInfoRequest.SMB2QueryInfoType.SMB2_0_INFO_FILESYSTEM, null, null, FileSystemInformationClass.FileFsFullSizeInformation).getOutputBuffer();
            try {
                ShareInfo shareInfo = ShareInfo.parseFsFullSizeInformation(new Buffer.PlainBuffer(outputBuffer, Endian.LE));
                return shareInfo;
            }
            catch (Buffer.BufferException e) {
                try {
                    throw new SMBRuntimeException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public void rmdir(String path, boolean recursive) throws SMBApiException {
        if (recursive) {
            List<FileIdBothDirectoryInformation> list = this.list(path);
            for (FileIdBothDirectoryInformation fi : list) {
                if (fi.getFileName().equals(".") || fi.getFileName().equals("..")) continue;
                String childPath = path + "\\" + fi.getFileName();
                if (!EnumWithValue.EnumUtils.isSet(fi.getFileAttributes(), FileAttributes.FILE_ATTRIBUTE_DIRECTORY)) {
                    this.rm(childPath);
                    continue;
                }
                this.rmdir(childPath, true);
            }
            this.rmdir(path, false);
        } else {
            try (DiskEntry e = this.open(path, EnumSet.of(AccessMask.DELETE), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_DIRECTORY), EnumSet.of(SMB2ShareAccess.FILE_SHARE_DELETE, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));){
                e.deleteOnClose();
            }
        }
    }

    public void rm(String path) throws SMBApiException {
        try (DiskEntry e = this.open(path, EnumSet.of(AccessMask.DELETE), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.of(SMB2ShareAccess.FILE_SHARE_DELETE, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE));){
            e.deleteOnClose();
        }
    }

    public void deleteOnClose(SMB2FileId fileId) {
        this.setFileInformation(fileId, new FileDispositionInformation(true));
    }

    public SecurityDescriptor getSecurityInfo(String path, Set<SecurityInformation> securityInfo) throws SMBApiException {
        EnumSet<AccessMask> accessMask = EnumSet.of(AccessMask.GENERIC_READ);
        if (securityInfo.contains(SecurityInformation.SACL_SECURITY_INFORMATION)) {
            accessMask.add(AccessMask.ACCESS_SYSTEM_SECURITY);
        }
        try (DiskEntry e = this.open(path, accessMask, null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            SecurityDescriptor securityDescriptor = e.getSecurityInformation(securityInfo);
            return securityDescriptor;
        }
    }

    public SecurityDescriptor getSecurityInfo(SMB2FileId fileId, Set<SecurityInformation> securityInfo) throws SMBApiException {
        byte[] outputBuffer = this.queryInfo(fileId, SMB2QueryInfoRequest.SMB2QueryInfoType.SMB2_0_INFO_SECURITY, securityInfo, null, null).getOutputBuffer();
        try {
            return SecurityDescriptor.read(new SMBBuffer(outputBuffer));
        }
        catch (Buffer.BufferException e) {
            throw new SMBRuntimeException(e);
        }
    }

    public void setSecurityInfo(String path, Set<SecurityInformation> securityInfo, SecurityDescriptor securityDescriptor) throws SMBApiException {
        EnumSet<AccessMask> accessMask = EnumSet.of(AccessMask.GENERIC_WRITE);
        if (securityInfo.contains(SecurityInformation.SACL_SECURITY_INFORMATION)) {
            accessMask.add(AccessMask.ACCESS_SYSTEM_SECURITY);
        }
        if (securityInfo.contains(SecurityInformation.OWNER_SECURITY_INFORMATION)) {
            accessMask.add(AccessMask.WRITE_OWNER);
        }
        if (securityInfo.contains(SecurityInformation.DACL_SECURITY_INFORMATION)) {
            accessMask.add(AccessMask.WRITE_DAC);
        }
        try (DiskEntry e = this.open(path, accessMask, null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            e.setSecurityInformation(securityDescriptor, securityInfo);
        }
    }

    public void setSecurityInfo(SMB2FileId fileId, Set<SecurityInformation> securityInfo, SecurityDescriptor securityDescriptor) throws SMBApiException {
        SMBBuffer buffer = new SMBBuffer();
        securityDescriptor.write(buffer);
        this.setInfo(fileId, SMB2SetInfoRequest.SMB2InfoType.SMB2_0_INFO_SECURITY, securityInfo, null, buffer.getCompactData());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSmbPath() + "]";
    }
}

