/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import com.hierynomus.sshj.secg.SecgUtils;
import com.hierynomus.sshj.signature.Ed25519PublicKey;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KeyType {
    RSA("ssh-rsa"){

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            BigInteger n;
            BigInteger e;
            try {
                e = buf.readMPInt();
                n = buf.readMPInt();
            }
            catch (Buffer.BufferException be) {
                throw new GeneralSecurityException(be);
            }
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
            return keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            RSAPublicKey rsaKey = (RSAPublicKey)pk;
            ((Buffer)((Buffer)buf.putString(this.sType)).putMPInt(rsaKey.getPublicExponent())).putMPInt(rsaKey.getModulus());
        }

        @Override
        protected boolean isMyType(Key key) {
            return key instanceof RSAPublicKey || key instanceof RSAPrivateKey;
        }
    }
    ,
    DSA("ssh-dss"){

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            BigInteger y;
            BigInteger g;
            BigInteger q;
            BigInteger p;
            try {
                p = buf.readMPInt();
                q = buf.readMPInt();
                g = buf.readMPInt();
                y = buf.readMPInt();
            }
            catch (Buffer.BufferException be) {
                throw new GeneralSecurityException(be);
            }
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
            return keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            DSAPublicKey dsaKey = (DSAPublicKey)pk;
            ((Buffer)((Buffer)((Buffer)((Buffer)buf.putString(this.sType)).putMPInt(dsaKey.getParams().getP())).putMPInt(dsaKey.getParams().getQ())).putMPInt(dsaKey.getParams().getG())).putMPInt(dsaKey.getY());
        }

        @Override
        protected boolean isMyType(Key key) {
            return key instanceof DSAPublicKey || key instanceof DSAPrivateKey;
        }
    }
    ,
    ECDSA("ecdsa-sha2-nistp256"){
        private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            try {
                String curveName = buf.readString();
                int keyLen = buf.readUInt32AsInt();
                byte x04 = buf.readByte();
                byte[] x = new byte[(keyLen - 1) / 2];
                byte[] y = new byte[(keyLen - 1) / 2];
                buf.readRawBytes(x);
                buf.readRawBytes(y);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("Key algo: %s, Key curve: %s, Key Len: %s, 0x04: %s\nx: %s\ny: %s", type, curveName, keyLen, x04, Arrays.toString(x), Arrays.toString(y)));
                }
                if (!KeyType.NISTP_CURVE.equals(curveName)) {
                    throw new GeneralSecurityException(String.format("Unknown curve %s", curveName));
                }
                BigInteger bigX = new BigInteger(1, x);
                BigInteger bigY = new BigInteger(1, y);
                X9ECParameters ecParams = NISTNamedCurves.getByName((String)"p-256");
                ECPoint pPublicPoint = ecParams.getCurve().createPoint(bigX, bigY);
                ECParameterSpec spec = new ECParameterSpec(ecParams.getCurve(), ecParams.getG(), ecParams.getN());
                ECPublicKeySpec publicSpec = new ECPublicKeySpec(pPublicPoint, spec);
                KeyFactory keyFactory = KeyFactory.getInstance("ECDSA");
                return keyFactory.generatePublic((KeySpec)publicSpec);
            }
            catch (Exception ex) {
                throw new GeneralSecurityException(ex);
            }
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            ECPublicKey ecdsa = (ECPublicKey)pk;
            byte[] encoded = SecgUtils.getEncoded(ecdsa.getW(), ecdsa.getParams().getCurve());
            ((Buffer)((Buffer)buf.putString(this.sType)).putString(KeyType.NISTP_CURVE)).putBytes(encoded);
        }

        @Override
        protected boolean isMyType(Key key) {
            return "ECDSA".equals(key.getAlgorithm());
        }
    }
    ,
    ED25519("ssh-ed25519"){
        private final Logger logger = LoggerFactory.getLogger(KeyType.class);

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            try {
                int keyLen = buf.readUInt32AsInt();
                byte[] p = new byte[keyLen];
                buf.readRawBytes(p);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Key algo: %s, Key curve: 25519, Key Len: %s\np: %s", type, keyLen, Arrays.toString(p)));
                }
                EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
                GroupElement point = ed25519.getCurve().createPoint(p, true);
                EdDSAPublicKeySpec publicSpec = new EdDSAPublicKeySpec(point, (EdDSAParameterSpec)ed25519);
                return new Ed25519PublicKey(publicSpec);
            }
            catch (Buffer.BufferException be) {
                throw new SSHRuntimeException(be);
            }
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            EdDSAPublicKey key = (EdDSAPublicKey)pk;
            ((Buffer)buf.putString(this.sType)).putBytes(key.getAbyte());
        }

        @Override
        protected boolean isMyType(Key key) {
            return "EdDSA".equals(key.getAlgorithm());
        }
    }
    ,
    UNKNOWN("unknown"){

        @Override
        public PublicKey readPubKeyFromBuffer(String type, Buffer<?> buf) throws GeneralSecurityException {
            throw new UnsupportedOperationException("Don't know how to decode key:" + type);
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            throw new UnsupportedOperationException("Don't know how to encode key: " + pk);
        }

        @Override
        protected boolean isMyType(Key key) {
            return false;
        }
    };

    private static final String NISTP_CURVE = "nistp256";
    protected final String sType;

    private KeyType(String type) {
        this.sType = type;
    }

    public abstract PublicKey readPubKeyFromBuffer(String var1, Buffer<?> var2) throws GeneralSecurityException;

    public abstract void putPubKeyIntoBuffer(PublicKey var1, Buffer<?> var2);

    protected abstract boolean isMyType(Key var1);

    public static KeyType fromKey(Key key) {
        for (KeyType kt : KeyType.values()) {
            if (!kt.isMyType(key)) continue;
            return kt;
        }
        return UNKNOWN;
    }

    public static KeyType fromString(String sType) {
        for (KeyType kt : KeyType.values()) {
            if (!kt.sType.equals(sType)) continue;
            return kt;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.sType;
    }
}

