/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import javax.crypto.spec.DHParameterSpec;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.kex.AbstractDH;
import net.schmizz.sshj.transport.kex.DH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHGex
extends AbstractDH {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int minBits = 1024;
    private int maxBits = 8192;
    private int preferredBits = 2048;

    public AbstractDHGex(Digest digest) {
        super(new DH(), digest);
    }

    @Override
    public void init(Transport trans, String V_S, String V_C, byte[] I_S, byte[] I_C) throws GeneralSecurityException, TransportException {
        super.init(trans, V_S, V_C, I_S, I_C);
        this.digest.init();
        this.log.debug("Sending {}", (Object)Message.KEX_DH_GEX_REQUEST);
        trans.write((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.KEX_DH_GEX_REQUEST).putUInt32(this.minBits)).putUInt32(this.preferredBits)).putUInt32(this.maxBits));
    }

    @Override
    public boolean next(Message msg, SSHPacket buffer) throws GeneralSecurityException, TransportException {
        this.log.debug("Got message {}", (Object)msg);
        try {
            switch (msg) {
                case KEXDH_31: {
                    return this.parseGexGroup(buffer);
                }
                case KEX_DH_GEX_REPLY: {
                    return this.parseGexReply(buffer);
                }
            }
        }
        catch (Buffer.BufferException be) {
            throw new TransportException(be);
        }
        throw new TransportException("Unexpected message " + (Object)((Object)msg));
    }

    private boolean parseGexReply(SSHPacket buffer) throws Buffer.BufferException, GeneralSecurityException, TransportException {
        byte[] K_S = buffer.readBytes();
        byte[] f = buffer.readBytes();
        byte[] sig = buffer.readBytes();
        this.hostKey = new Buffer.PlainBuffer(K_S).readPublicKey();
        this.dh.computeK(f);
        BigInteger k = this.dh.getK();
        Buffer.PlainBuffer buf = (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)this.initializedBuffer().putString(K_S)).putUInt32(this.minBits)).putUInt32(this.preferredBits)).putUInt32(this.maxBits)).putMPInt(((DH)this.dh).getP())).putMPInt(((DH)this.dh).getG())).putBytes(this.dh.getE())).putBytes(f)).putMPInt(k);
        this.digest.update(buf.array(), buf.rpos(), buf.available());
        this.H = this.digest.digest();
        Signature signature = (Signature)Factory.Named.Util.create(this.trans.getConfig().getSignatureFactories(), KeyType.fromKey(this.hostKey).toString());
        signature.init(this.hostKey, null);
        signature.update(this.H, 0, this.H.length);
        if (!signature.verify(sig)) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "KeyExchange signature verification failed");
        }
        return true;
    }

    private boolean parseGexGroup(SSHPacket buffer) throws Buffer.BufferException, GeneralSecurityException, TransportException {
        BigInteger p = buffer.readMPInt();
        BigInteger g = buffer.readMPInt();
        int bitLength = p.bitLength();
        if (bitLength < this.minBits || bitLength > this.maxBits) {
            throw new GeneralSecurityException("Server generated gex p is out of range (" + bitLength + " bits)");
        }
        this.log.debug("Received server p bitlength {}", (Object)bitLength);
        this.dh.init(new DHParameterSpec(p, g));
        this.log.debug("Sending {}", (Object)Message.KEX_DH_GEX_INIT);
        this.trans.write((SSHPacket)new SSHPacket(Message.KEX_DH_GEX_INIT).putBytes(this.dh.getE()));
        return false;
    }
}

