/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import djb.Curve25519;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import net.schmizz.sshj.transport.kex.DHBase;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class Curve25519DH
extends DHBase {
    private byte[] secretKey;

    public Curve25519DH() {
        super("ECDSA", "ECDH");
    }

    @Override
    void computeK(byte[] f) throws GeneralSecurityException {
        byte[] k = new byte[32];
        Curve25519.curve(k, this.secretKey, f);
        this.setK(new BigInteger(1, k));
    }

    @Override
    public void init(AlgorithmParameterSpec params) throws GeneralSecurityException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] secretBytes = new byte[32];
        secureRandom.nextBytes(secretBytes);
        byte[] publicBytes = new byte[32];
        Curve25519.keygen(publicBytes, null, secretBytes);
        this.secretKey = Arrays.copyOf(secretBytes, secretBytes.length);
        this.setE(publicBytes);
    }

    public static AlgorithmParameterSpec getCurve25519Params() {
        X9ECParameters ecP = CustomNamedCurves.getByName((String)"curve25519");
        return new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }
}

