/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.kex.DHBase;
import net.schmizz.sshj.transport.random.Random;

public class DH
extends DHBase {
    private BigInteger p;
    private BigInteger g;

    public DH() {
        super("DH", "DH");
    }

    @Override
    protected void init(AlgorithmParameterSpec params, Factory<Random> randomFactory) throws GeneralSecurityException {
        if (!(params instanceof DHParameterSpec)) {
            throw new SSHRuntimeException("Wrong algorithm parameters for Diffie Hellman");
        }
        this.p = ((DHParameterSpec)params).getP();
        this.g = ((DHParameterSpec)params).getG();
        this.generator.initialize(params);
        KeyPair kp = this.generator.generateKeyPair();
        this.agreement.init(kp.getPrivate());
        this.setE(((DHPublicKey)kp.getPublic()).getY().toByteArray());
    }

    @Override
    void computeK(byte[] f) throws GeneralSecurityException {
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("DH");
        PublicKey yourPubKey = keyFactory.generatePublic(new DHPublicKeySpec(new BigInteger(f), this.p, this.g));
        this.agreement.doPhase(yourPubKey, true);
        this.setK(new BigInteger(1, this.agreement.generateSecret()));
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }
}

