/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.Check;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.ViewProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CheckViewProperties
extends ViewProperties {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.CHECK;
    public static final String SERIALIZED_NAME_SHAPE = "shape";
    @SerializedName(value="shape")
    private ShapeEnum shape = ShapeEnum.CHRONOGRAF_V2;
    public static final String SERIALIZED_NAME_CHECK_I_D = "checkID";
    @SerializedName(value="checkID")
    private String checkID;
    public static final String SERIALIZED_NAME_CHECK = "check";
    @SerializedName(value="check")
    private Check check = null;
    public static final String SERIALIZED_NAME_QUERIES = "queries";
    @SerializedName(value="queries")
    private List<DashboardQuery> queries = new ArrayList<DashboardQuery>();
    public static final String SERIALIZED_NAME_COLORS = "colors";
    @SerializedName(value="colors")
    private List<String> colors = new ArrayList<String>();

    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(required=true, value="")
    public ShapeEnum getShape() {
        return this.shape;
    }

    public CheckViewProperties checkID(String checkID) {
        this.checkID = checkID;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getCheckID() {
        return this.checkID;
    }

    public void setCheckID(String checkID) {
        this.checkID = checkID;
    }

    public CheckViewProperties check(Check check) {
        this.check = check;
        return this;
    }

    @ApiModelProperty(value="")
    public Check getCheck() {
        return this.check;
    }

    public void setCheck(Check check) {
        this.check = check;
    }

    public CheckViewProperties queries(List<DashboardQuery> queries) {
        this.queries = queries;
        return this;
    }

    public CheckViewProperties addQueriesItem(DashboardQuery queriesItem) {
        this.queries.add(queriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<DashboardQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DashboardQuery> queries) {
        this.queries = queries;
    }

    public CheckViewProperties colors(List<String> colors) {
        this.colors = colors;
        return this;
    }

    public CheckViewProperties addColorsItem(String colorsItem) {
        this.colors.add(colorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Colors define color encoding of data into a visualization")
    public List<String> getColors() {
        return this.colors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckViewProperties checkViewProperties = (CheckViewProperties)o;
        return Objects.equals((Object)this.type, (Object)checkViewProperties.type) && Objects.equals((Object)this.shape, (Object)checkViewProperties.shape) && Objects.equals(this.checkID, checkViewProperties.checkID) && Objects.equals(this.check, checkViewProperties.check) && Objects.equals(this.queries, checkViewProperties.queries) && Objects.equals(this.colors, checkViewProperties.colors) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.shape, this.checkID, this.check, this.queries, this.colors, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckViewProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString((Object)this.shape)).append("\n");
        sb.append("    checkID: ").append(this.toIndentedString(this.checkID)).append("\n");
        sb.append("    check: ").append(this.toIndentedString(this.check)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    colors: ").append(this.toIndentedString(this.colors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShapeEnum {
        CHRONOGRAF_V2("chronograf-v2");

        private String value;

        private ShapeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShapeEnum fromValue(String text) {
            for (ShapeEnum b : ShapeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShapeEnum> {
            public void write(JsonWriter jsonWriter, ShapeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShapeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShapeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CHECK("check");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

