/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.LabelsApi;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelCreateRequest;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelUpdate;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.service.LabelsService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class LabelsApiImpl
extends AbstractRestClient
implements LabelsApi {
    private static final Logger LOG = Logger.getLogger(LabelsApiImpl.class.getName());
    private final LabelsService service;

    LabelsApiImpl(@Nonnull LabelsService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Label createLabel(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNotNull(properties, (String)"properties");
        LabelCreateRequest label = new LabelCreateRequest();
        label.setName(name);
        label.setProperties(properties);
        label.setOrgID(orgID);
        return this.createLabel(label);
    }

    @Override
    @Nonnull
    public Label createLabel(@Nonnull LabelCreateRequest request) {
        Arguments.checkNotNull((Object)request, (String)"request");
        Call<LabelResponse> call = this.service.postLabels(request);
        LabelResponse labelResponse = (LabelResponse)this.execute(call);
        LOG.log(Level.FINEST, "createLabel response: {0}", labelResponse);
        return labelResponse.getLabel();
    }

    @Override
    @Nonnull
    public Label updateLabel(@Nonnull Label label) {
        Arguments.checkNotNull((Object)label, (String)"label");
        LabelUpdate labelUpdate = new LabelUpdate();
        labelUpdate.properties(label.getProperties());
        return this.updateLabel(label.getId(), labelUpdate);
    }

    @Override
    @Nonnull
    public Label updateLabel(@Nonnull String labelID, @Nonnull LabelUpdate labelUpdate) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNotNull((Object)labelUpdate, (String)"labelUpdate");
        Call<LabelResponse> call = this.service.patchLabelsID(labelID, labelUpdate, null);
        LabelResponse labelResponse = (LabelResponse)this.execute(call);
        LOG.log(Level.FINEST, "updateLabel response: {0}", labelResponse);
        return labelResponse.getLabel();
    }

    @Override
    public void deleteLabel(@Nonnull Label label) {
        Arguments.checkNotNull((Object)label, (String)"label");
        this.deleteLabel(label.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Call<Void> call = this.service.deleteLabelsID(labelID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Label cloneLabel(@Nonnull String clonedName, @Nonnull String labelID) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Label label = this.findLabelByID(labelID);
        if (label == null) {
            throw new IllegalStateException("NotFound Label with ID: " + labelID);
        }
        return this.cloneLabel(clonedName, label);
    }

    @Override
    @Nonnull
    public Label cloneLabel(@Nonnull String clonedName, @Nonnull Label label) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNotNull((Object)label, (String)"label");
        LabelCreateRequest cloned = new LabelCreateRequest();
        cloned.setName(clonedName);
        cloned.setOrgID(label.getOrgID());
        if (label.getProperties() != null) {
            label.getProperties().forEach(cloned::putPropertiesItem);
        }
        cloned.getProperties().putAll(label.getProperties());
        return this.createLabel(cloned);
    }

    @Override
    @Nonnull
    public Label findLabelByID(@Nonnull String labelID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Call<LabelResponse> call = this.service.getLabelsID(labelID, null);
        return ((LabelResponse)this.execute(call)).getLabel();
    }

    @Override
    @Nonnull
    public List<Label> findLabels() {
        return this.findLabelsByOrgId(null);
    }

    @Override
    @Nonnull
    public List<Label> findLabelsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"organization");
        return this.findLabelsByOrgId(organization.getId());
    }

    @Override
    @Nonnull
    public List<Label> findLabelsByOrgId(@Nullable String orgID) {
        Call<LabelsResponse> sourcesCall = this.service.getLabels(null, orgID);
        LabelsResponse labels = (LabelsResponse)this.execute(sourcesCall);
        LOG.log(Level.FINEST, "findLabels found: {0}", labels);
        return labels.getLabels();
    }
}

