/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.TemplatesApi;
import com.influxdb.client.domain.Document;
import com.influxdb.client.domain.DocumentCreate;
import com.influxdb.client.domain.DocumentListEntry;
import com.influxdb.client.domain.DocumentUpdate;
import com.influxdb.client.domain.Documents;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.service.TemplatesService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import javax.annotation.Nonnull;
import retrofit2.Call;

final class TemplatesApiImpl
extends AbstractRestClient
implements TemplatesApi {
    private final TemplatesService service;

    TemplatesApiImpl(@Nonnull TemplatesService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Document createTemplate(@Nonnull DocumentCreate templateCreate) {
        Arguments.checkNotNull((Object)templateCreate, (String)"documentCreate");
        Call<Document> call = this.service.postDocumentsTemplates(templateCreate, null);
        return (Document)this.execute(call);
    }

    @Override
    @Nonnull
    public Document updateTemplate(@Nonnull Document template) {
        Arguments.checkNotNull((Object)template, (String)"template");
        DocumentUpdate update = new DocumentUpdate().meta(template.getMeta()).content(template.getContent());
        return this.updateTemplate(template.getId(), update);
    }

    @Override
    @Nonnull
    public Document updateTemplate(@Nonnull String templateID, @Nonnull DocumentUpdate template) {
        Arguments.checkNonEmpty((String)templateID, (String)"templateID");
        Arguments.checkNotNull((Object)template, (String)"template");
        Call<Document> call = this.service.putDocumentsTemplatesID(templateID, template, null);
        return (Document)this.execute(call);
    }

    @Override
    public void deleteTemplate(@Nonnull Document template) {
        Arguments.checkNotNull((Object)template, (String)"template");
        this.deleteTemplate(template.getId());
    }

    @Override
    public void deleteTemplate(@Nonnull String templateID) {
        Arguments.checkNonEmpty((String)templateID, (String)"templateID");
        Call<Void> call = this.service.deleteDocumentsTemplatesID(templateID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Document template) {
        Arguments.checkNotNull((Object)template, (String)"template");
        return this.getLabels(template.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String templateID) {
        Arguments.checkNonEmpty((String)templateID, (String)"templateID");
        Call<LabelsResponse> call = this.service.getDocumentsTemplatesIDLabels(templateID, null);
        return ((LabelsResponse)this.execute(call)).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Document template) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)template, (String)"template");
        return this.addLabel(label.getId(), template.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String templateID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)templateID, (String)"templateID");
        LabelMapping mapping = new LabelMapping().labelID(labelID);
        Call<LabelResponse> call = this.service.postDocumentsTemplatesIDLabels(templateID, mapping, null);
        return (LabelResponse)this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Document template) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)template, (String)"template");
        this.deleteLabel(label.getId(), template.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String templateID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)templateID, (String)"templateID");
        Call<Void> call = this.service.deleteDocumentsTemplatesIDLabelsID(templateID, labelID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Document cloneTemplate(@Nonnull String clonedName, @Nonnull String templateID) {
        Arguments.checkNonEmpty((String)templateID, (String)"templateID");
        return this.cloneTemplate(clonedName, this.findTemplateByID(templateID));
    }

    @Override
    @Nonnull
    public Document cloneTemplate(@Nonnull String clonedName, @Nonnull Document template) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNotNull((Object)template, (String)"template");
        DocumentCreate documentCreate = new DocumentCreate();
        documentCreate.meta(template.getMeta().name(clonedName).description(template.getMeta().getDescription())).content(template.getContent());
        if (template.getLabels() != null) {
            template.getLabels().forEach(label -> documentCreate.addLabelsItem(label.getName()));
        }
        return this.createTemplate(documentCreate);
    }

    @Override
    @Nonnull
    public Document findTemplateByID(@Nonnull String templateID) {
        Arguments.checkNonEmpty((String)templateID, (String)"templateID");
        Call<Document> call = this.service.getDocumentsTemplatesID(templateID, null);
        return (Document)this.execute(call);
    }

    @Override
    @Nonnull
    public List<DocumentListEntry> findTemplates(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"organization");
        return this.findTemplates(organization.getName());
    }

    @Override
    @Nonnull
    public List<DocumentListEntry> findTemplates(@Nonnull String orgName) {
        Arguments.checkNonEmpty((String)orgName, (String)"orgName");
        Call<Documents> call = this.service.getDocumentsTemplates(null, orgName, null);
        return ((Documents)this.execute(call)).getDocuments();
    }
}

