/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.service;

import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.OperationLogs;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.Organizations;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.SecretKeys;
import com.influxdb.client.domain.SecretKeysResponse;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface OrganizationsService {
    @DELETE(value="api/v2/orgs/{orgID}")
    public Call<Void> deleteOrgsID(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @DELETE(value="api/v2/orgs/{orgID}/labels/{labelID}")
    public Call<Void> deleteOrgsIDLabelsID(@Path(value="orgID") String var1, @Path(value="labelID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/orgs/{orgID}/members/{userID}")
    public Call<Void> deleteOrgsIDMembersID(@Path(value="userID") String var1, @Path(value="orgID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/orgs/{orgID}/owners/{userID}")
    public Call<Void> deleteOrgsIDOwnersID(@Path(value="userID") String var1, @Path(value="orgID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/orgs")
    public Call<Organizations> getOrgs(@Header(value="Zap-Trace-Span") String var1, @Query(value="org") String var2, @Query(value="orgID") String var3);

    @GET(value="api/v2/orgs/{orgID}")
    public Call<Organization> getOrgsID(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/orgs/{orgID}/labels")
    public Call<LabelsResponse> getOrgsIDLabels(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/orgs/{orgID}/logs")
    public Call<OperationLogs> getOrgsIDLogs(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2, @Query(value="offset") Integer var3, @Query(value="limit") Integer var4);

    @GET(value="api/v2/orgs/{orgID}/members")
    public Call<ResourceMembers> getOrgsIDMembers(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/orgs/{orgID}/owners")
    public Call<ResourceOwners> getOrgsIDOwners(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/orgs/{orgID}/secrets")
    public Call<SecretKeysResponse> getOrgsIDSecrets(@Path(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/orgs/{orgID}")
    public Call<Organization> patchOrgsID(@Path(value="orgID") String var1, @Body Organization var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/orgs/{orgID}/secrets")
    public Call<Void> patchOrgsIDSecrets(@Path(value="orgID") String var1, @Body Map<String, String> var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/orgs")
    public Call<Organization> postOrgs(@Body Organization var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/orgs/{orgID}/labels")
    public Call<LabelResponse> postOrgsIDLabels(@Path(value="orgID") String var1, @Body LabelMapping var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/orgs/{orgID}/members")
    public Call<ResourceMember> postOrgsIDMembers(@Path(value="orgID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/orgs/{orgID}/owners")
    public Call<ResourceOwner> postOrgsIDOwners(@Path(value="orgID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/orgs/{orgID}/secrets/delete")
    public Call<Void> postOrgsIDSecrets(@Path(value="orgID") String var1, @Body SecretKeys var2, @Header(value="Zap-Trace-Span") String var3);
}

