/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.properties;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.layout.properties.TransparentColor;

public class Underline {
    protected TransparentColor transparentColor;
    protected float thickness;
    protected float thicknessMul;
    protected float yPosition;
    protected float yPositionMul;
    protected int lineCapStyle = 0;
    private TransparentColor strokeColor;
    private float strokeWidth = 0.0f;
    private float[] dashArray = null;
    private float dashPhase = 0.0f;

    public Underline(Color color, float thickness, float thicknessMul, float yPosition, float yPositionMul, int lineCapStyle) {
        this(color, 1.0f, thickness, thicknessMul, yPosition, yPositionMul, lineCapStyle);
    }

    public Underline(Color color, float opacity, float thickness, float thicknessMul, float yPosition, float yPositionMul, int lineCapStyle) {
        this.transparentColor = new TransparentColor(color, opacity);
        this.thickness = thickness;
        this.thicknessMul = thicknessMul;
        this.yPosition = yPosition;
        this.yPositionMul = yPositionMul;
        this.lineCapStyle = lineCapStyle;
    }

    public Color getColor() {
        return this.transparentColor.getColor();
    }

    public float getOpacity() {
        return this.transparentColor.getOpacity();
    }

    public float getThickness(float fontSize) {
        return this.thickness + this.thicknessMul * fontSize;
    }

    public float getYPosition(float fontSize) {
        return this.yPosition + this.yPositionMul * fontSize;
    }

    public float getYPositionMul() {
        return this.yPositionMul;
    }

    public int getLineCapStyle() {
        return this.lineCapStyle;
    }

    public TransparentColor getStrokeColor() {
        return this.strokeColor;
    }

    public Underline setStrokeColor(TransparentColor strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public Underline setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        return this;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public Underline setDashPattern(float[] dashArray, float dashPhase) {
        this.dashArray = dashArray;
        this.dashPhase = dashPhase;
        return this;
    }
}

