/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.properties.grid.GridFlow;
import com.itextpdf.layout.renderer.GridCell;
import com.itextpdf.layout.renderer.GridView;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

class Grid {
    private GridCell[][] rows = new GridCell[1][1];
    private int rowOffset = 0;
    private int columnOffset = 0;
    private final List<Collection<GridCell>> uniqueCells = new ArrayList<Collection<GridCell>>(2);
    private final List<GridCell> itemsWithoutPlace = new ArrayList<GridCell>();

    Grid(int initialRowsCount, int initialColumnsCount, int columnOffset, int rowOffset) {
        this.resize(initialRowsCount, initialColumnsCount);
        this.columnOffset = columnOffset;
        this.rowOffset = rowOffset;
        this.uniqueCells.add(null);
        this.uniqueCells.add(null);
    }

    final GridCell[][] getRows() {
        return this.rows;
    }

    final int getNumberOfRows() {
        return this.rows.length;
    }

    final int getNumberOfColumns() {
        return this.rows.length > 0 ? this.rows[0].length : 0;
    }

    int getRowOffset() {
        return this.rowOffset;
    }

    int getColumnOffset() {
        return this.columnOffset;
    }

    Collection<GridCell> getUniqueGridCells(GridOrder iterationOrder) {
        LinkedHashSet<GridCell> result = new LinkedHashSet<GridCell>();
        if (this.uniqueCells.get(iterationOrder.ordinal()) != null) {
            return this.uniqueCells.get(iterationOrder.ordinal());
        }
        if (GridOrder.COLUMN.equals((Object)iterationOrder)) {
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                for (int i = 0; i < this.getNumberOfRows(); ++i) {
                    if (this.rows[i][j] == null) continue;
                    result.add(this.rows[i][j]);
                }
            }
            result.addAll(this.itemsWithoutPlace);
            this.uniqueCells.set(iterationOrder.ordinal(), result);
            return result;
        }
        GridCell[][] gridCellArray = this.rows;
        int n = gridCellArray.length;
        for (int i = 0; i < n; ++i) {
            GridCell[] cellsRow;
            for (GridCell cell : cellsRow = gridCellArray[i]) {
                if (cell == null) continue;
                result.add(cell);
            }
        }
        result.addAll(this.itemsWithoutPlace);
        this.uniqueCells.set(iterationOrder.ordinal(), result);
        return result;
    }

    final void resize(int height, int width) {
        if (height <= this.getNumberOfRows() && width <= this.getNumberOfColumns()) {
            return;
        }
        GridCell[][] resizedRows = height > this.getNumberOfRows() ? new GridCell[height][] : this.rows;
        int gridWidth = Math.max(width, this.getNumberOfColumns());
        for (int i = 0; i < resizedRows.length; ++i) {
            GridCell[] row;
            if (i < this.getNumberOfRows()) {
                if (width <= this.rows[i].length) {
                    resizedRows[i] = this.rows[i];
                    continue;
                }
                row = new GridCell[width];
                System.arraycopy(this.rows[i], 0, row, 0, this.rows[i].length);
                resizedRows[i] = row;
                continue;
            }
            row = new GridCell[gridWidth];
            resizedRows[i] = row;
        }
        this.rows = resizedRows;
    }

    int collapseNullLines(GridOrder order, int minSize) {
        int i;
        int nullLinesStart = this.determineNullLinesStart(order);
        if (nullLinesStart == -1) {
            return GridOrder.ROW.equals((Object)order) ? this.getNumberOfRows() : this.getNumberOfColumns();
        }
        nullLinesStart = Math.max(minSize, nullLinesStart);
        int rowsNumber = GridOrder.ROW.equals((Object)order) ? nullLinesStart : this.getNumberOfRows();
        int colsNumber = GridOrder.COLUMN.equals((Object)order) ? nullLinesStart : this.getNumberOfColumns();
        GridCell[][] shrankGrid = new GridCell[rowsNumber][];
        for (i = 0; i < shrankGrid.length; ++i) {
            shrankGrid[i] = new GridCell[colsNumber];
        }
        for (i = 0; i < shrankGrid.length; ++i) {
            System.arraycopy(this.rows[i], 0, shrankGrid[i], 0, shrankGrid[0].length);
        }
        this.rows = shrankGrid;
        return GridOrder.ROW.equals((Object)order) ? this.getNumberOfRows() : this.getNumberOfColumns();
    }

    private void addCell(GridCell cell) {
        boolean placeFound = false;
        for (int i = cell.getRowStart(); i < cell.getRowEnd(); ++i) {
            for (int j = cell.getColumnStart(); j < cell.getColumnEnd(); ++j) {
                if (this.rows[i][j] != null) continue;
                this.rows[i][j] = cell;
                placeFound = true;
            }
        }
        if (!placeFound) {
            this.itemsWithoutPlace.add(cell);
        }
    }

    private int determineNullLinesStart(GridOrder order) {
        if (GridOrder.ROW.equals((Object)order)) {
            for (int i = 0; i < this.getNumberOfRows(); ++i) {
                boolean isNull = true;
                for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                    if (this.getRows()[i][j] == null) continue;
                    isNull = false;
                    break;
                }
                if (!isNull) continue;
                return i;
            }
            return -1;
        }
        if (GridOrder.COLUMN.equals((Object)order)) {
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                boolean isNull = true;
                for (int i = 0; i < this.getNumberOfRows(); ++i) {
                    if (this.getRows()[i][j] == null) continue;
                    isNull = false;
                    break;
                }
                if (!isNull) continue;
                return j;
            }
            return -1;
        }
        return -1;
    }

    private static class CellPlacementHelper {
        private final GridView view;
        private final Grid grid;

        CellPlacementHelper(Grid grid, GridFlow flow) {
            this.view = new GridView(grid, flow);
            this.grid = grid;
        }

        void fit(GridCell cell) {
            this.grid.resize(cell.getRowEnd(), cell.getColumnEnd());
            GridView.Pos pos = this.view.reset(cell.getRowStart(), cell.getColumnStart(), cell.getGridWidth(), cell.getGridHeight());
            for (int i = 0; i < Math.max(cell.getGridHeight(), cell.getGridWidth()) + 1; ++i) {
                while (this.view.hasNext()) {
                    boolean result = this.view.fit(cell.getGridWidth(), cell.getGridHeight());
                    if (result) {
                        cell.setPos(pos.getY(), pos.getX());
                        return;
                    }
                    pos = this.view.next();
                }
                if (this.view.isFixed()) break;
                this.view.increaseDefaultAxis();
            }
        }
    }

    private static class CssGridCell {
        IRenderer value;
        int startX;
        int spanX;
        int offsetX;
        int startY;
        int spanY;
        int offsetY;

        CssGridCell(IRenderer value, int templateSizeX, int templateSizeY) {
            this.value = value;
            int[] rowPlacement = CssGridCell.initAxisPlacement((Integer)value.getProperty(150), (Integer)value.getProperty(149), (Integer)value.getProperty(101), templateSizeY);
            this.startY = rowPlacement[0];
            this.spanY = rowPlacement[1];
            this.offsetY = rowPlacement[2];
            int[] columnPlacement = CssGridCell.initAxisPlacement((Integer)value.getProperty(148), (Integer)value.getProperty(147), (Integer)value.getProperty(9), templateSizeX);
            this.startX = columnPlacement[0];
            this.spanX = columnPlacement[1];
            this.offsetX = columnPlacement[2];
        }

        private static int[] initAxisPlacement(Integer startProperty, Integer endProperty, Integer spanProperty, int templateSize) {
            int start = startProperty == null ? 0 : startProperty;
            int end = endProperty == null ? 0 : endProperty;
            int span = spanProperty == null ? 1 : spanProperty;
            int[] result = new int[]{0, span, 0};
            if (start < 0) {
                if (Math.abs(start) <= templateSize + 1) {
                    ++start;
                }
                start = templateSize + start + 1;
            }
            if (end < 0) {
                if (Math.abs(end) <= templateSize + 1) {
                    ++end;
                }
                end = templateSize + end + 1;
            }
            if (start != 0 && end != 0) {
                if (start < end) {
                    result[0] = start;
                    result[1] = end - start;
                } else if (start == end) {
                    result[0] = start;
                } else {
                    result[0] = end;
                    result[1] = start - end;
                }
                if (start * end < 0) {
                    result[1] = result[1] - 1;
                }
            } else if (start != 0) {
                result[0] = start;
            } else if (end != 0) {
                start = end - span;
                if (start > 0 || end > 0) {
                    // empty if block
                }
                result[0] = --start;
            }
            if (start < 0 || end < 0) {
                result[2] = Math.abs(Math.min(start, end));
            }
            return result;
        }
    }

    private static final class ColumnCellComparator
    implements Comparator<GridCell> {
        private ColumnCellComparator() {
        }

        @Override
        public int compare(GridCell lhs, GridCell rhs) {
            return Integer.compare(this.calculateModifiers(rhs), this.calculateModifiers(lhs));
        }

        private int calculateModifiers(GridCell value) {
            if (value.getColumnStart() != -1 && value.getRowStart() != -1) {
                return 2;
            }
            if (value.getColumnStart() != -1) {
                return 1;
            }
            return 0;
        }
    }

    private static final class RowCellComparator
    implements Comparator<GridCell> {
        private RowCellComparator() {
        }

        @Override
        public int compare(GridCell lhs, GridCell rhs) {
            return Integer.compare(this.calculateModifiers(rhs), this.calculateModifiers(lhs));
        }

        private int calculateModifiers(GridCell value) {
            if (value.getColumnStart() != -1 && value.getRowStart() != -1) {
                return 2;
            }
            if (value.getRowStart() != -1) {
                return 1;
            }
            return 0;
        }
    }

    static final class Builder {
        private int explicitColumnCount = 0;
        private int explicitRowCount = 0;
        private GridFlow flow;
        private List<IRenderer> values;

        private Builder() {
        }

        static Builder forItems(List<IRenderer> values) {
            Builder builder = new Builder();
            builder.values = values;
            return builder;
        }

        public Builder columns(int explicitColumnCount) {
            this.explicitColumnCount = explicitColumnCount;
            return this;
        }

        public Builder rows(int explicitRowCount) {
            this.explicitRowCount = explicitRowCount;
            return this;
        }

        public Builder flow(GridFlow flow) {
            this.flow = flow;
            return this;
        }

        public Grid build() {
            AtomicLong rowOffset = new AtomicLong();
            AtomicLong columnOffset = new AtomicLong();
            List cssCells = this.values.stream().map(val -> {
                CssGridCell cell = new CssGridCell((IRenderer)val, this.explicitColumnCount, this.explicitRowCount);
                rowOffset.set(Math.max(rowOffset.get(), (long)cell.offsetY));
                columnOffset.set(Math.max(columnOffset.get(), (long)cell.offsetX));
                return cell;
            }).collect(Collectors.toList());
            List<GridCell> cells = cssCells.stream().map(cssCell -> {
                int startY = -1;
                if (cssCell.startY < 0) {
                    startY = cssCell.startY + (int)rowOffset.get();
                } else if (cssCell.startY > 0) {
                    startY = cssCell.startY + (int)rowOffset.get() - 1;
                }
                int startX = -1;
                if (cssCell.startX < 0) {
                    startX = cssCell.startX + (int)columnOffset.get();
                } else if (cssCell.startX > 0) {
                    startX = cssCell.startX + (int)columnOffset.get() - 1;
                }
                return new GridCell(cssCell.value, startX, startY, cssCell.spanX, cssCell.spanY);
            }).collect(Collectors.toList());
            Collections.sort(cells, Builder.getOrderingFunctionForFlow(this.flow));
            int columnCount = Math.max(this.explicitColumnCount + (int)columnOffset.get(), Builder.calculateInitialColumnsCount(cells));
            int rowCount = Math.max(this.explicitRowCount + (int)rowOffset.get(), Builder.calculateInitialRowsCount(cells));
            Grid grid = new Grid(rowCount, columnCount, (int)columnOffset.get(), (int)rowOffset.get());
            CellPlacementHelper cellPlacementHelper = new CellPlacementHelper(grid, this.flow);
            for (GridCell cell : cells) {
                cellPlacementHelper.fit(cell);
                grid.addCell(cell);
            }
            return grid;
        }

        private static int calculateInitialColumnsCount(Collection<GridCell> cells) {
            int initialColumnsCount = 1;
            for (GridCell cell : cells) {
                if (cell == null) continue;
                initialColumnsCount = Math.max(cell.getGridWidth(), Math.max(initialColumnsCount, cell.getColumnEnd()));
            }
            return initialColumnsCount;
        }

        private static int calculateInitialRowsCount(Collection<GridCell> cells) {
            int initialRowsCount = 1;
            for (GridCell cell : cells) {
                if (cell == null) continue;
                initialRowsCount = Math.max(cell.getGridHeight(), Math.max(initialRowsCount, cell.getRowEnd()));
            }
            return initialRowsCount;
        }

        static Comparator<GridCell> getOrderingFunctionForFlow(GridFlow flow) {
            if (GridFlow.COLUMN.equals((Object)flow) || GridFlow.COLUMN_DENSE.equals((Object)flow)) {
                return new ColumnCellComparator();
            }
            return new RowCellComparator();
        }
    }

    static enum GridOrder {
        ROW,
        COLUMN;

    }
}

