/*
 * Decompiled with CFR 0.152.
 */
package com.itsaky.androidide.utils;

import com.itsaky.androidide.utils.AndroidLogger;
import com.itsaky.androidide.utils.JvmLogger;
import com.itsaky.androidide.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public abstract class ILogger {
    public static final String DEFAULT_TAG = "AndroidIDE";
    public static final String MSG_SEPARATOR = " ";
    private static final List<LogListener> logListeners = new ArrayList<LogListener>();
    private static final Map<String, ILogger> cachedLoggers = new WeakHashMap<String, ILogger>();
    protected final String TAG;
    protected boolean isEnabled = true;

    protected ILogger(String tag) {
        this.TAG = LogUtils.preProcessLogTag(tag);
    }

    public static ILogger instance() {
        return cachedLoggers.computeIfAbsent(DEFAULT_TAG, ILogger::createInstance);
    }

    private static ILogger createInstance(String tag) {
        return cachedLoggers.computeIfAbsent(tag, ILogger::newPlatformDependentLogger);
    }

    private static ILogger newPlatformDependentLogger(String tag) {
        return LogUtils.isJvm() ? new JvmLogger(tag) : new AndroidLogger(tag);
    }

    public static void addLogListener(LogListener listener) {
        logListeners.add(Objects.requireNonNull(listener));
    }

    public static void removeLogListener(LogListener listener) {
        logListeners.remove(Objects.requireNonNull(listener));
    }

    public static ILogger newInstance(String tag) {
        return ILogger.createInstance(tag);
    }

    public ILogger error(Object ... messages) {
        return this.log(Level.ERROR, messages);
    }

    public ILogger log(Level level, Object ... messages) {
        this.logAndNotify(level, this.generateMessage(messages));
        return this;
    }

    private void logAndNotify(Level level, String msg) {
        if (!this.isEnabled()) {
            return;
        }
        this.doLog(level, msg);
        for (LogListener listener : logListeners) {
            listener.log(level, this.TAG, msg);
        }
    }

    protected abstract void doLog(Level var1, String var2);

    protected String generateMessage(Object ... messages) {
        StringBuilder sb = new StringBuilder();
        if (messages == null) {
            return "null";
        }
        for (Object msg : messages) {
            sb.append(msg instanceof Throwable ? "\n" : MSG_SEPARATOR);
            sb.append(msg instanceof Throwable ? LogUtils.getFullStackTrace((Throwable)msg) : msg);
            sb.append(msg instanceof Throwable ? "\n" : MSG_SEPARATOR);
        }
        return sb.toString();
    }

    public ILogger warn(Object ... messages) {
        return this.log(Level.WARNING, messages);
    }

    public ILogger verbose(Object ... messages) {
        return this.log(Level.VERBOSE, messages);
    }

    public ILogger info(Object ... messages) {
        return this.log(Level.INFO, messages);
    }

    public void logThis() {
        this.debug(this.getCallerClassDescription());
    }

    public ILogger debug(Object ... messages) {
        return this.log(Level.DEBUG, messages);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected String getCallerClassDescription() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        int elementsLength = elements.length;
        for (int i = 1; i < elementsLength; ++i) {
            StackTraceElement element = elements[i];
            String klass = element.getClassName();
            String method = element.getMethodName();
            if (ILogger.class.getName().equals(klass) || klass.contains("java.lang.Thread")) continue;
            return String.format("%s [%s]", method, klass);
        }
        return "<Logger> <Cannot get caller information>";
    }

    public static interface LogListener {
        public void log(Level var1, String var2, String var3);
    }

    public static enum Level {
        DEBUG('D'),
        WARNING('W'),
        ERROR('E'),
        INFO('I'),
        VERBOSE('V');

        public final char levelChar;

        private Level(char levelChar) {
            this.levelChar = levelChar;
        }

        public static Level forChar(char c) {
            c = Character.toUpperCase(c);
            for (Level value : Level.values()) {
                if (value.levelChar != c) continue;
                return value;
            }
            throw new IllegalArgumentException("Invalid level char " + c);
        }
    }
}

