/*
 * Decompiled with CFR 0.152.
 */
package com.itsaky.androidide.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogUtils {
    private static final String LINE_SEP = System.getProperty("line.separator");

    public static boolean isJvm() {
        try {
            Class.forName("org.junit.runners.JUnit4");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("android.content.Context");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
    }

    public static String preProcessLogTag(String tag) {
        String regex = "[^a-z-A-Z0-9_.]";
        Matcher matcher = Pattern.compile("[^a-z-A-Z0-9_.]").matcher(tag);
        if (matcher.find()) {
            tag = tag.replaceAll("[^a-z-A-Z0-9_.]", "_");
        }
        return tag;
    }

    public static String getFullStackTrace(Throwable throwable) {
        ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
        while (throwable != null && !throwableList.contains(throwable)) {
            throwableList.add(throwable);
            throwable = throwable.getCause();
        }
        int size = throwableList.size();
        ArrayList<Object> frames = new ArrayList<Object>();
        List<String> nextTrace = LogUtils.getStackFrameList((Throwable)throwableList.get(size - 1));
        int i = size;
        while (--i >= 0) {
            List<String> trace = nextTrace;
            if (i != 0) {
                nextTrace = LogUtils.getStackFrameList((Throwable)throwableList.get(i - 1));
                LogUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == size - 1) {
                frames.add(((Throwable)throwableList.get(i)).toString());
            } else {
                frames.add(" Caused by: " + ((Throwable)throwableList.get(i)).toString());
            }
            frames.addAll(trace);
        }
        StringBuilder sb = new StringBuilder();
        for (String string : frames) {
            sb.append(string).append(LINE_SEP);
        }
        return sb.toString();
    }

    private static List<String> getStackFrameList(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        String stackTrace = sw.toString();
        StringTokenizer frames = new StringTokenizer(stackTrace, LINE_SEP);
        ArrayList<String> list = new ArrayList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token = frames.nextToken();
            int at = token.indexOf("at");
            if (at != -1 && token.substring(0, at).trim().isEmpty()) {
                traceStarted = true;
                list.add(token);
                continue;
            }
            if (!traceStarted) continue;
            break;
        }
        return list;
    }

    private static void removeCommonFrames(List<String> causeFrames, List<String> wrapperFrames) {
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }
}

