/*
 * Decompiled with CFR 0.152.
 */
package com.itsaky.androidide.logsender;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.itsaky.androidide.logsender.ILogSender;

public interface ILogReceiver
extends IInterface {
    public static final String DESCRIPTOR = "com.itsaky.androidide.logsender.ILogReceiver";

    public void ping() throws RemoteException;

    public void connect(ILogSender var1) throws RemoteException;

    public void disconnect(String var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILogReceiver {
        static final int TRANSACTION_ping = 1;
        static final int TRANSACTION_connect = 2;
        static final int TRANSACTION_disconnect = 3;

        public Stub() {
            this.attachInterface(this, ILogReceiver.DESCRIPTOR);
        }

        public static ILogReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILogReceiver.DESCRIPTOR);
            if (iin != null && iin instanceof ILogReceiver) {
                return (ILogReceiver)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILogReceiver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.ping();
                    break;
                }
                case 2: {
                    ILogSender _arg0 = ILogSender.Stub.asInterface(data.readStrongBinder());
                    this.connect(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.disconnect(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ILogReceiver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILogReceiver.DESCRIPTOR;
            }

            @Override
            public void ping() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogReceiver.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(ILogSender sender) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogReceiver.DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)sender);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(String packageName, String senderId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogReceiver.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(senderId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILogReceiver {
        @Override
        public void ping() throws RemoteException {
        }

        @Override
        public void connect(ILogSender sender) throws RemoteException {
        }

        @Override
        public void disconnect(String packageName, String senderId) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

