/*
 * Decompiled with CFR 0.152.
 */
package com.itsaky.androidide.logsender;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.IBinder;
import android.widget.Toast;
import com.itsaky.androidide.logsender.LogSender;
import com.itsaky.androidide.logsender.R;
import com.itsaky.androidide.logsender.utils.Logger;

public class LogSenderService
extends Service {
    private final LogSender logSender = new LogSender();
    private static final int NOTIFICATION_ID = 644;
    private static final String NOTIFICATION_CHANNEL_NAME = "LogSender Service";
    private static final String NOTIFICATION_TITLE = "LogSender Service";
    private static final String NOTIFICATION_TEXT = "Connected to AndroidIDE";
    private static final String NOTIFICATION_CHANNEL_ID = "ide.logsender.service";
    public static final String ACTION_START_SERVICE = "ide.logsender.service.start";
    public static final String ACTION_STOP_SERVICE = "ide.logsender.service.stop";

    public void onCreate() {
        Logger.LOG.logThis();
        super.onCreate();
        this.setupNotificationChannel();
        this.startForeground(644, this.buildNotification());
    }

    public IBinder onBind(Intent intent) {
        Logger.debug("Unexpected request to bind.", intent);
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Logger.debug("onStartCommand", intent, flags, startId);
        switch (intent.getAction()) {
            case "ide.logsender.service.start": {
                this.actionStartService();
                break;
            }
            case "ide.logsender.service.stop": {
                this.actionStopService();
                break;
            }
            default: {
                Logger.error("Unknown service action:", intent.getAction());
            }
        }
        return 2;
    }

    private void actionStartService() {
        Logger.info("Starting log sender service...");
        boolean result = false;
        try {
            result = this.logSender.bind(this.getApplicationContext());
            Logger.debug("Bind to AndroidIDE:", result);
        }
        catch (Exception err) {
            Logger.error(this.getString(R.string.msg_bind_service_failed), err);
        }
        if (!result) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.msg_bind_service_failed), (int)0).show();
            this.actionStopService();
        }
    }

    private void actionStopService() {
        Logger.info("Stopping log sender service...");
        this.stopSelf();
    }

    public void onTaskRemoved(Intent rootIntent) {
        Logger.LOG.logThis();
        if (!this.logSender.isConnected() && !this.logSender.isBinding()) {
            Logger.debug("Not bound to AndroidIDE. Ignored.");
            return;
        }
        Logger.warn("Task removed. Destroying log sender...");
        this.logSender.destroy(this.getApplicationContext());
        this.stopSelf();
    }

    public void onDestroy() {
        Logger.LOG.logThis();
        if (!this.logSender.isConnected() && !this.logSender.isBinding()) {
            Logger.debug("Not bound to AndroidIDE. Ignored.");
            return;
        }
        Logger.warn("Service is being destroyed. Destroying log sender...");
        this.logSender.destroy(this.getApplicationContext());
        super.onDestroy();
    }

    private void setupNotificationChannel() {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        NotificationChannel channel = new NotificationChannel(NOTIFICATION_CHANNEL_ID, (CharSequence)"LogSender Service", 2);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService(NotificationManager.class);
        if (notificationManager != null) {
            notificationManager.createNotificationChannel(channel);
        }
    }

    private Notification buildNotification() {
        Resources res = this.getResources();
        int priority = -1;
        Notification.Builder builder = new Notification.Builder((Context)this);
        builder.setContentTitle((CharSequence)"LogSender Service");
        builder.setContentText((CharSequence)NOTIFICATION_TEXT);
        builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)NOTIFICATION_TEXT));
        builder.setPriority(priority);
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId(NOTIFICATION_CHANNEL_ID);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            builder.setShowWhen(false);
        }
        builder.setSmallIcon(R.drawable.ic_androidide_log);
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setColor(-10453621);
        }
        builder.setOngoing(true);
        Intent exitIntent = new Intent((Context)this, LogSenderService.class).setAction(ACTION_STOP_SERVICE);
        builder.addAction(17301533, (CharSequence)res.getString(R.string.notification_action_exit), PendingIntent.getService((Context)this, (int)0, (Intent)exitIntent, (int)0x4000000));
        return builder.build();
    }
}

