/*
 * Decompiled with CFR 0.152.
 */
package com.itsaky.androidide.logsender.utils;

import com.itsaky.androidide.logsender.socket.ISocketCommand;
import com.itsaky.androidide.logsender.socket.SenderInfoCommand;
import com.itsaky.androidide.logsender.utils.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;

public class LogReader
extends Thread {
    private final String senderId;
    private final String packageName;
    private final int port;
    private final ProcessBuilder processBuilder;
    private final AtomicBoolean isInterrupted = new AtomicBoolean(false);

    public LogReader(String senderId, String packageName, int port) {
        this(senderId, packageName, port, LogReader.defaultCmd());
    }

    public LogReader(String senderId, String packageName, int port, String[] cmd) {
        super("AndroidIDE-LogReader");
        this.senderId = senderId;
        this.packageName = packageName;
        this.port = port;
        this.processBuilder = new ProcessBuilder(cmd);
        this.processBuilder.redirectErrorStream(true);
    }

    private static String[] defaultCmd() {
        return new String[]{"logcat", "-v", "threadtime"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.info("Starting to read logs...");
        try (Socket socket = new Socket(InetAddress.getLocalHost(), this.port);){
            Process process = this.processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                OutputStream outputStream = socket.getOutputStream();
                this.writeCommand(new SenderInfoCommand(this.senderId, this.packageName), outputStream);
                while (!this.isInterrupted.get() && (line = reader.readLine()) != null) {
                    line = line + "\n";
                    outputStream.write(line.getBytes());
                }
            }
            catch (IOException ioError) {
                Logger.error("Error reading from the logcat process or writing to the socket", ioError);
            }
            finally {
                socket.close();
            }
        }
        catch (IOException ioError) {
            Logger.error("Error creating the socket or starting the process", ioError);
        }
    }

    private void writeCommand(ISocketCommand command, OutputStream outputStream) throws IOException {
        outputStream.write(command.toString().getBytes());
    }

    public void cancel() {
        this.isInterrupted.set(true);
        this.interrupt();
    }
}

