/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.CompositeListener;
import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.utils.DetailData;

public final class ListenerType
implements DetailData {
    JAMonListener listener;
    private Object lockObj;

    ListenerType(Object lockObj) {
        this.lockObj = lockObj;
    }

    private CompositeListener addCompositeListener(JAMonListener listenerToAdd) {
        if (this.listener instanceof CompositeListener) {
            return ((CompositeListener)this.listener).addListener(listenerToAdd);
        }
        return new CompositeListener().addListener(this.listener).addListener(listenerToAdd);
    }

    public final JAMonListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JAMonListener listenerToAdd) {
        Object object = this.lockObj;
        synchronized (object) {
            this.listener = this.listener == null || listenerToAdd == null ? listenerToAdd : this.addCompositeListener(listenerToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAMonListener getListener(String listenerName) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return null;
            }
            if (this.listener.getName().equalsIgnoreCase(listenerName)) {
                return this.listener;
            }
            if (this.listener instanceof CompositeListener) {
                return ((CompositeListener)this.listener).getListener(listenerName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String listenerName) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return;
            }
            if (this.listener.getName().equalsIgnoreCase(listenerName)) {
                this.listener = null;
            } else if (this.listener instanceof CompositeListener) {
                CompositeListener compListener = (CompositeListener)this.listener;
                compListener.removeListener(listenerName);
                if (compListener.getNumListeners() == 0) {
                    this.listener = null;
                } else if (compListener.getNumListeners() == 1) {
                    this.listener = compListener.getListener(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Object object = this.lockObj;
        synchronized (object) {
            return this.listener != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListener(String listenerName) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return false;
            }
            if (this.listener.getName().equalsIgnoreCase(listenerName)) {
                return true;
            }
            if (this.listener instanceof CompositeListener) {
                return ((CompositeListener)this.listener).hasListener(listenerName);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getData() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return null;
            }
            if (this.listener instanceof CompositeListener) {
                CompositeListener compListener = (CompositeListener)this.listener;
                return compListener.getData();
            }
            return new CompositeListener().addListener(this.listener).getData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeader() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener instanceof CompositeListener) {
                CompositeListener compListener = (CompositeListener)this.listener;
                return compListener.getHeader();
            }
            return new CompositeListener().getHeader();
        }
    }

    private static void test(ListenerType lt, String name) {
        System.out.print(lt.hasListener(name) + "-");
        JAMonListener l = lt.getListener(name);
        if (l != null) {
            System.out.print(l.getName() + ",");
        }
    }

    private static void testDisp(ListenerType lt) {
        System.out.println();
        System.out.print("*");
        Object[][] data = lt.getData();
        int rows = data == null ? 0 : data.length;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                System.out.print(data[i][j] + ", ");
            }
        }
    }

    public static void main(String[] args) {
        ListenerType lt = new ListenerType(new Object());
        CompositeListener cl1 = new CompositeListener("cl1");
        CompositeListener cl2 = new CompositeListener("cl2");
        cl1.addListener(new JAMonBufferListener("buff1"));
        cl1.addListener(new JAMonBufferListener("buff2"));
        cl2.addListener(new JAMonBufferListener("buff3"));
        cl2.addListener(new JAMonBufferListener("buff4"));
        cl1.addListener(cl2);
        lt.addListener(cl1);
        lt.addListener(new JAMonBufferListener("buff5"));
        ListenerType.test(lt, "cl1");
        ListenerType.test(lt, "cl2");
        ListenerType.test(lt, "buff2");
        ListenerType.test(lt, "buff4");
        ListenerType.test(lt, "buffX");
        ListenerType.testDisp(lt);
        lt.removeListener("buff4");
        ListenerType.testDisp(lt);
        lt.removeListener("cl2");
        ListenerType.testDisp(lt);
        lt.removeListener("buff1");
        lt.removeListener("buff2");
        ListenerType.testDisp(lt);
        lt.removeListener("buff5");
        ListenerType.testDisp(lt);
        lt.addListener(cl2);
        ListenerType.testDisp(lt);
    }
}

