/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.integration.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.zxing.integration.android.IntentResult;
import com.journeyapps.barcodescanner.CaptureActivity;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntentIntegrator {
    public static final int REQUEST_CODE = 49374;
    private static final String TAG = IntentIntegrator.class.getSimpleName();
    public static final String UPC_A = "UPC_A";
    public static final String UPC_E = "UPC_E";
    public static final String EAN_8 = "EAN_8";
    public static final String EAN_13 = "EAN_13";
    public static final String RSS_14 = "RSS_14";
    public static final String CODE_39 = "CODE_39";
    public static final String CODE_93 = "CODE_93";
    public static final String CODE_128 = "CODE_128";
    public static final String ITF = "ITF";
    public static final String RSS_EXPANDED = "RSS_EXPANDED";
    public static final String QR_CODE = "QR_CODE";
    public static final String DATA_MATRIX = "DATA_MATRIX";
    public static final String PDF_417 = "PDF_417";
    public static final Collection<String> PRODUCT_CODE_TYPES = IntentIntegrator.list("UPC_A", "UPC_E", "EAN_8", "EAN_13", "RSS_14");
    public static final Collection<String> ONE_D_CODE_TYPES = IntentIntegrator.list("UPC_A", "UPC_E", "EAN_8", "EAN_13", "RSS_14", "CODE_39", "CODE_93", "CODE_128", "ITF", "RSS_14", "RSS_EXPANDED");
    public static final Collection<String> ALL_CODE_TYPES = null;
    private final Activity activity;
    private Fragment fragment;
    private android.support.v4.app.Fragment supportFragment;
    private final Map<String, Object> moreExtras = new HashMap<String, Object>(3);
    private Collection<String> desiredBarcodeFormats;
    private Class<?> captureActivity;
    private int requestCode = 49374;

    protected Class<?> getDefaultCaptureActivity() {
        return CaptureActivity.class;
    }

    public IntentIntegrator(Activity activity) {
        this.activity = activity;
    }

    public Class<?> getCaptureActivity() {
        if (this.captureActivity == null) {
            this.captureActivity = this.getDefaultCaptureActivity();
        }
        return this.captureActivity;
    }

    public IntentIntegrator setCaptureActivity(Class<?> captureActivity) {
        this.captureActivity = captureActivity;
        return this;
    }

    public IntentIntegrator setRequestCode(int requestCode) {
        if (requestCode <= 0 || requestCode > 65535) {
            throw new IllegalArgumentException("requestCode out of range");
        }
        this.requestCode = requestCode;
        return this;
    }

    public static IntentIntegrator forSupportFragment(android.support.v4.app.Fragment fragment) {
        IntentIntegrator integrator = new IntentIntegrator((Activity)fragment.getActivity());
        integrator.supportFragment = fragment;
        return integrator;
    }

    @TargetApi(value=11)
    public static IntentIntegrator forFragment(Fragment fragment) {
        IntentIntegrator integrator = new IntentIntegrator(fragment.getActivity());
        integrator.fragment = fragment;
        return integrator;
    }

    public Map<String, ?> getMoreExtras() {
        return this.moreExtras;
    }

    public final IntentIntegrator addExtra(String key, Object value) {
        this.moreExtras.put(key, value);
        return this;
    }

    public final IntentIntegrator setPrompt(String prompt) {
        if (prompt != null) {
            this.addExtra("PROMPT_MESSAGE", prompt);
        }
        return this;
    }

    public IntentIntegrator setOrientationLocked(boolean locked) {
        this.addExtra("SCAN_ORIENTATION_LOCKED", locked);
        return this;
    }

    public IntentIntegrator setCameraId(int cameraId) {
        if (cameraId >= 0) {
            this.addExtra("SCAN_CAMERA_ID", cameraId);
        }
        return this;
    }

    public IntentIntegrator setBeepEnabled(boolean enabled) {
        this.addExtra("BEEP_ENABLED", enabled);
        return this;
    }

    public IntentIntegrator setBarcodeImageEnabled(boolean enabled) {
        this.addExtra("BARCODE_IMAGE_ENABLED", enabled);
        return this;
    }

    public IntentIntegrator setDesiredBarcodeFormats(Collection<String> desiredBarcodeFormats) {
        this.desiredBarcodeFormats = desiredBarcodeFormats;
        return this;
    }

    public IntentIntegrator setDesiredBarcodeFormats(String ... desiredBarcodeFormats) {
        this.desiredBarcodeFormats = Arrays.asList(desiredBarcodeFormats);
        return this;
    }

    public final void initiateScan() {
        this.startActivityForResult(this.createScanIntent(), this.requestCode);
    }

    public IntentIntegrator setTimeout(long timeout) {
        this.addExtra("TIMEOUT", timeout);
        return this;
    }

    public Intent createScanIntent() {
        Intent intentScan = new Intent((Context)this.activity, this.getCaptureActivity());
        intentScan.setAction("com.google.zxing.client.android.SCAN");
        if (this.desiredBarcodeFormats != null) {
            StringBuilder joinedByComma = new StringBuilder();
            for (String format : this.desiredBarcodeFormats) {
                if (joinedByComma.length() > 0) {
                    joinedByComma.append(',');
                }
                joinedByComma.append(format);
            }
            intentScan.putExtra("SCAN_FORMATS", joinedByComma.toString());
        }
        intentScan.addFlags(0x4000000);
        intentScan.addFlags(524288);
        this.attachMoreExtras(intentScan);
        return intentScan;
    }

    public final void initiateScan(Collection<String> desiredBarcodeFormats) {
        this.setDesiredBarcodeFormats(desiredBarcodeFormats);
        this.initiateScan();
    }

    protected void startActivityForResult(Intent intent, int code) {
        if (this.fragment != null) {
            this.fragment.startActivityForResult(intent, code);
        } else if (this.supportFragment != null) {
            this.supportFragment.startActivityForResult(intent, code);
        } else {
            this.activity.startActivityForResult(intent, code);
        }
    }

    protected void startActivity(Intent intent) {
        if (this.fragment != null) {
            this.fragment.startActivity(intent);
        } else if (this.supportFragment != null) {
            this.supportFragment.startActivity(intent);
        } else {
            this.activity.startActivity(intent);
        }
    }

    public static IntentResult parseActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 49374) {
            return IntentIntegrator.parseActivityResult(resultCode, intent);
        }
        return null;
    }

    public static IntentResult parseActivityResult(int resultCode, Intent intent) {
        if (resultCode == -1) {
            String contents = intent.getStringExtra("SCAN_RESULT");
            String formatName = intent.getStringExtra("SCAN_RESULT_FORMAT");
            byte[] rawBytes = intent.getByteArrayExtra("SCAN_RESULT_BYTES");
            int intentOrientation = intent.getIntExtra("SCAN_RESULT_ORIENTATION", Integer.MIN_VALUE);
            Integer orientation = intentOrientation == Integer.MIN_VALUE ? null : Integer.valueOf(intentOrientation);
            String errorCorrectionLevel = intent.getStringExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL");
            String barcodeImagePath = intent.getStringExtra("SCAN_RESULT_IMAGE_PATH");
            return new IntentResult(contents, formatName, rawBytes, orientation, errorCorrectionLevel, barcodeImagePath);
        }
        return new IntentResult();
    }

    private static List<String> list(String ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    private void attachMoreExtras(Intent intent) {
        for (Map.Entry<String, Object> entry : this.moreExtras.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                intent.putExtra(key, (Serializable)((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                intent.putExtra(key, (Serializable)((Long)value));
                continue;
            }
            if (value instanceof Boolean) {
                intent.putExtra(key, (Serializable)((Boolean)value));
                continue;
            }
            if (value instanceof Double) {
                intent.putExtra(key, (Serializable)((Double)value));
                continue;
            }
            if (value instanceof Float) {
                intent.putExtra(key, (Serializable)((Float)value));
                continue;
            }
            if (value instanceof Bundle) {
                intent.putExtra(key, (Bundle)value);
                continue;
            }
            intent.putExtra(key, value.toString());
        }
    }
}

