/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Reader;
import com.journeyapps.barcodescanner.Decoder;
import com.journeyapps.barcodescanner.DecoderFactory;
import com.journeyapps.barcodescanner.InvertedDecoder;
import com.journeyapps.barcodescanner.MixedDecoder;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

public class DefaultDecoderFactory
implements DecoderFactory {
    private Collection<BarcodeFormat> decodeFormats;
    private Map<DecodeHintType, ?> hints;
    private String characterSet;
    private int scanType;

    public DefaultDecoderFactory() {
    }

    public DefaultDecoderFactory(Collection<BarcodeFormat> decodeFormats) {
        this.decodeFormats = decodeFormats;
    }

    public DefaultDecoderFactory(Collection<BarcodeFormat> decodeFormats, Map<DecodeHintType, ?> hints, String characterSet, int scanType) {
        this.decodeFormats = decodeFormats;
        this.hints = hints;
        this.characterSet = characterSet;
        this.scanType = scanType;
    }

    @Override
    public Decoder createDecoder(Map<DecodeHintType, ?> baseHints) {
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        hints.putAll(baseHints);
        if (this.hints != null) {
            hints.putAll(this.hints);
        }
        if (this.decodeFormats != null) {
            hints.put(DecodeHintType.POSSIBLE_FORMATS, (Object)this.decodeFormats);
        }
        if (this.characterSet != null) {
            hints.put(DecodeHintType.CHARACTER_SET, (Object)this.characterSet);
        }
        MultiFormatReader reader = new MultiFormatReader();
        reader.setHints(hints);
        switch (this.scanType) {
            case 0: {
                return new Decoder((Reader)reader);
            }
            case 1: {
                return new InvertedDecoder((Reader)reader);
            }
            case 2: {
                return new MixedDecoder((Reader)reader);
            }
        }
        return new Decoder((Reader)reader);
    }
}

