/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.framework.bcelbundle;

import com.kirkk.analyzer.framework.JarClass;
import com.kirkk.analyzer.framework.JarPackage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JarPackageImpl
implements JarPackage {
    private String packageName;
    private List classes;

    public JarPackageImpl(String string) {
        if (string == null) {
            throw new NullPointerException("Package name cannot be null");
        }
        this.packageName = string;
    }

    public void addClass(JarClass jarClass) {
        if (this.classes == null) {
            this.classes = new ArrayList();
        }
        this.classes.add(jarClass);
    }

    public List getClasses() {
        return this.classes;
    }

    public int getClassCount() {
        return this.classes.size();
    }

    public String getLongName() {
        return this.packageName;
    }

    public boolean equals(Object object) {
        if (object instanceof JarPackage) {
            JarPackage jarPackage = (JarPackage)object;
            if (this.getLongName().equals(jarPackage.getLongName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }

    public List getImportedPackageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            JarClass jarClass = (JarClass)iterator.next();
            Iterator iterator2 = jarClass.getImportedPackageNames().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }
}

