/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.core.httpclient;

import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.request.FormData;
import com.lark.oapi.core.request.FormDataFile;
import com.lark.oapi.core.request.RawRequest;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClientTransport
implements IHttpTransport {
    private CloseableHttpClient httpclient;

    private ApacheHttpClientTransport(Builder builder) {
        this.httpclient = builder.httpclient;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void Close() throws IOException {
        this.httpclient.close();
    }

    @Override
    public RawResponse execute(RawRequest rawRequest) throws Exception {
        final String httpMethod = rawRequest.getHttpMethod();
        HttpEntityEnclosingRequestBase request = new HttpEntityEnclosingRequestBase(){

            public String getMethod() {
                return httpMethod;
            }
        };
        request.setURI(URI.create(rawRequest.getReqUrl()));
        for (Map.Entry<String, List<String>> entry : rawRequest.getHeaders().entrySet()) {
            String key = entry.getKey();
            for (String string : entry.getValue()) {
                request.addHeader(key, string);
            }
        }
        if (rawRequest.getBody() != null) {
            Object body = rawRequest.getBody();
            if (body instanceof FormData) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                builder.setContentType(ContentType.create((String)ContentType.MULTIPART_FORM_DATA.getMimeType()));
                for (FormDataFile formDataFile : ((FormData)rawRequest.getBody()).getFiles()) {
                    builder.addBinaryBody(formDataFile.getFieldName(), formDataFile.getFile(), ContentType.APPLICATION_OCTET_STREAM, Strings.isEmpty(formDataFile.getFileName()) ? "unknown" : formDataFile.getFileName());
                }
                for (Map.Entry entry : ((FormData)rawRequest.getBody()).getParams().entrySet()) {
                    builder.addTextBody((String)entry.getKey(), (String)entry.getValue());
                }
                request.setEntity(builder.build());
            } else {
                StringEntity entity = new StringEntity(Jsons.LONG_TO_STR.toJson(rawRequest.getBody()), "UTF-8");
                request.setEntity((HttpEntity)entity);
            }
        }
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)request);
        byte[] result = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        RawResponse rawResponse = new RawResponse();
        rawResponse.setStatusCode(response.getStatusLine().getStatusCode());
        rawResponse.setBody(result);
        rawResponse.setContentType(rawResponse.getContentType());
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Header header : response.getAllHeaders()) {
            if (hashMap.containsKey(header.getName())) {
                ((List)hashMap.get(header.getName())).add(header.getValue());
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(header.getValue());
            hashMap.put(header.getName(), values);
        }
        rawResponse.setHeaders(hashMap);
        return rawResponse;
    }

    public static final class Builder {
        private CloseableHttpClient httpclient;

        private Builder() {
        }

        public Builder httpclient(CloseableHttpClient httpclient) {
            this.httpclient = httpclient;
            return this;
        }

        public ApacheHttpClientTransport build() {
            return new ApacheHttpClientTransport(this);
        }
    }
}

