/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.diff;

public class Update {
    public static final Update EMPTY = new Update("");
    private final String oldText;
    private final String newText;

    public Update(String equalText) {
        this(equalText, equalText);
    }

    public Update(String oldText, String newText) {
        this.oldText = oldText;
        this.newText = newText;
    }

    public boolean isChange() {
        return !this.newText.equals(this.oldText);
    }

    public Update appendToOld(String moreOld) {
        return new Update(this.oldText + moreOld, this.newText);
    }

    public Update appendToNew(String moreNew) {
        return new Update(this.oldText, this.newText + moreNew);
    }

    public String toString() {
        return this.isChange() ? "{" + this.oldText + "\u2192" + this.newText + "}" : this.oldText;
    }

    public boolean isEmpty() {
        return this.oldText.length() == 0 && this.newText.length() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Update update = (Update)o;
        if (this.newText != null ? !this.newText.equals(update.newText) : update.newText != null) {
            return false;
        }
        return !(this.oldText != null ? !this.oldText.equals(update.oldText) : update.oldText != null);
    }

    public int hashCode() {
        int result = this.oldText != null ? this.oldText.hashCode() : 0;
        result = 31 * result + (this.newText != null ? this.newText.hashCode() : 0);
        return result;
    }

    public Update appendToBoth(String text) {
        return new Update(this.oldText + text, this.newText + text);
    }

    public Update append(Update update) {
        return new Update(this.oldText + update.oldText, this.newText + update.newText);
    }
}

