/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.diff;

import com.google.common.collect.Lists;
import com.madgag.diff.Update;
import java.util.LinkedList;
import java.util.List;
import name.fraser.neil.plaintext.diff_match_patch;

public class UpdatesFromDiffConverter {
    public List<Update> convert(List<diff_match_patch.Diff> diffs) {
        UpdateSequence updateSequence = new UpdateSequence();
        for (diff_match_patch.Diff diff : diffs) {
            switch (diff.operation) {
                case EQUAL: {
                    updateSequence.append(new Update(diff.text));
                    break;
                }
                case INSERT: {
                    updateSequence.append(new Update("", diff.text));
                    break;
                }
                case DELETE: {
                    updateSequence.append(new Update(diff.text, ""));
                }
            }
        }
        return Lists.newArrayList((Iterable)updateSequence.updates);
    }

    public class UpdateSequence {
        private final LinkedList<Update> updates = new LinkedList();

        public void append(Update update) {
            if (update.isEmpty()) {
                return;
            }
            if (this.updates.isEmpty()) {
                this.updates.add(update);
                return;
            }
            Update previousUpdate = this.updates.getLast();
            if (previousUpdate.isChange() == update.isChange()) {
                this.updates.pollLast();
                this.updates.addLast(previousUpdate.append(update));
            } else {
                this.updates.addLast(update);
            }
        }
    }
}

