/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.DataMaskingRuleState;
import com.microsoft.azure.management.sql.DataMaskingFunction;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Represents a database data masking rule.
 */
@JsonFlatten
public class DataMaskingRuleInner extends ProxyResourceInner {
    /**
     * The rule Id.
     */
    @JsonProperty(value = "properties.id", access = JsonProperty.Access.WRITE_ONLY)
    private String dataMaskingRuleId;

    /**
     * The alias name. This is a legacy parameter and is no longer used.
     */
    @JsonProperty(value = "properties.aliasName")
    private String aliasName;

    /**
     * The rule state. Used to delete a rule. To delete an existing rule,
     * specify the schemaName, tableName, columnName, maskingFunction, and
     * specify ruleState as disabled. However, if the rule doesn't already
     * exist, the rule will be created with ruleState set to enabled,
     * regardless of the provided value of ruleState. Possible values include:
     * 'Disabled', 'Enabled'.
     */
    @JsonProperty(value = "properties.ruleState")
    private DataMaskingRuleState ruleState;

    /**
     * The schema name on which the data masking rule is applied.
     */
    @JsonProperty(value = "properties.schemaName", required = true)
    private String schemaName;

    /**
     * The table name on which the data masking rule is applied.
     */
    @JsonProperty(value = "properties.tableName", required = true)
    private String tableName;

    /**
     * The column name on which the data masking rule is applied.
     */
    @JsonProperty(value = "properties.columnName", required = true)
    private String columnName;

    /**
     * The masking function that is used for the data masking rule. Possible
     * values include: 'Default', 'CCN', 'Email', 'Number', 'SSN', 'Text'.
     */
    @JsonProperty(value = "properties.maskingFunction", required = true)
    private DataMaskingFunction maskingFunction;

    /**
     * The numberFrom property of the masking rule. Required if maskingFunction
     * is set to Number, otherwise this parameter will be ignored.
     */
    @JsonProperty(value = "properties.numberFrom")
    private String numberFrom;

    /**
     * The numberTo property of the data masking rule. Required if
     * maskingFunction is set to Number, otherwise this parameter will be
     * ignored.
     */
    @JsonProperty(value = "properties.numberTo")
    private String numberTo;

    /**
     * If maskingFunction is set to Text, the number of characters to show
     * unmasked in the beginning of the string. Otherwise, this parameter will
     * be ignored.
     */
    @JsonProperty(value = "properties.prefixSize")
    private String prefixSize;

    /**
     * If maskingFunction is set to Text, the number of characters to show
     * unmasked at the end of the string. Otherwise, this parameter will be
     * ignored.
     */
    @JsonProperty(value = "properties.suffixSize")
    private String suffixSize;

    /**
     * If maskingFunction is set to Text, the character to use for masking the
     * unexposed part of the string. Otherwise, this parameter will be ignored.
     */
    @JsonProperty(value = "properties.replacementString")
    private String replacementString;

    /**
     * The location of the data masking rule.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * The kind of Data Masking Rule. Metadata, used for Azure portal.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /**
     * Get the dataMaskingRuleId value.
     *
     * @return the dataMaskingRuleId value
     */
    public String dataMaskingRuleId() {
        return this.dataMaskingRuleId;
    }

    /**
     * Get the aliasName value.
     *
     * @return the aliasName value
     */
    public String aliasName() {
        return this.aliasName;
    }

    /**
     * Set the aliasName value.
     *
     * @param aliasName the aliasName value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withAliasName(String aliasName) {
        this.aliasName = aliasName;
        return this;
    }

    /**
     * Get the ruleState value.
     *
     * @return the ruleState value
     */
    public DataMaskingRuleState ruleState() {
        return this.ruleState;
    }

    /**
     * Set the ruleState value.
     *
     * @param ruleState the ruleState value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withRuleState(DataMaskingRuleState ruleState) {
        this.ruleState = ruleState;
        return this;
    }

    /**
     * Get the schemaName value.
     *
     * @return the schemaName value
     */
    public String schemaName() {
        return this.schemaName;
    }

    /**
     * Set the schemaName value.
     *
     * @param schemaName the schemaName value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    /**
     * Get the tableName value.
     *
     * @return the tableName value
     */
    public String tableName() {
        return this.tableName;
    }

    /**
     * Set the tableName value.
     *
     * @param tableName the tableName value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    /**
     * Get the columnName value.
     *
     * @return the columnName value
     */
    public String columnName() {
        return this.columnName;
    }

    /**
     * Set the columnName value.
     *
     * @param columnName the columnName value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    /**
     * Get the maskingFunction value.
     *
     * @return the maskingFunction value
     */
    public DataMaskingFunction maskingFunction() {
        return this.maskingFunction;
    }

    /**
     * Set the maskingFunction value.
     *
     * @param maskingFunction the maskingFunction value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withMaskingFunction(DataMaskingFunction maskingFunction) {
        this.maskingFunction = maskingFunction;
        return this;
    }

    /**
     * Get the numberFrom value.
     *
     * @return the numberFrom value
     */
    public String numberFrom() {
        return this.numberFrom;
    }

    /**
     * Set the numberFrom value.
     *
     * @param numberFrom the numberFrom value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withNumberFrom(String numberFrom) {
        this.numberFrom = numberFrom;
        return this;
    }

    /**
     * Get the numberTo value.
     *
     * @return the numberTo value
     */
    public String numberTo() {
        return this.numberTo;
    }

    /**
     * Set the numberTo value.
     *
     * @param numberTo the numberTo value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withNumberTo(String numberTo) {
        this.numberTo = numberTo;
        return this;
    }

    /**
     * Get the prefixSize value.
     *
     * @return the prefixSize value
     */
    public String prefixSize() {
        return this.prefixSize;
    }

    /**
     * Set the prefixSize value.
     *
     * @param prefixSize the prefixSize value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withPrefixSize(String prefixSize) {
        this.prefixSize = prefixSize;
        return this;
    }

    /**
     * Get the suffixSize value.
     *
     * @return the suffixSize value
     */
    public String suffixSize() {
        return this.suffixSize;
    }

    /**
     * Set the suffixSize value.
     *
     * @param suffixSize the suffixSize value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withSuffixSize(String suffixSize) {
        this.suffixSize = suffixSize;
        return this;
    }

    /**
     * Get the replacementString value.
     *
     * @return the replacementString value
     */
    public String replacementString() {
        return this.replacementString;
    }

    /**
     * Set the replacementString value.
     *
     * @param replacementString the replacementString value to set
     * @return the DataMaskingRuleInner object itself.
     */
    public DataMaskingRuleInner withReplacementString(String replacementString) {
        this.replacementString = replacementString;
        return this;
    }

    /**
     * Get the location value.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the kind value.
     *
     * @return the kind value
     */
    public String kind() {
        return this.kind;
    }

}
