/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.AutomaticTuningMode;
import java.util.Map;
import com.microsoft.azure.management.sql.AutomaticTuningOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Database-level Automatic Tuning.
 */
@JsonFlatten
public class DatabaseAutomaticTuningInner extends ProxyResourceInner {
    /**
     * Automatic tuning desired state. Possible values include: 'Inherit',
     * 'Custom', 'Auto', 'Unspecified'.
     */
    @JsonProperty(value = "properties.desiredState")
    private AutomaticTuningMode desiredState;

    /**
     * Automatic tuning actual state. Possible values include: 'Inherit',
     * 'Custom', 'Auto', 'Unspecified'.
     */
    @JsonProperty(value = "properties.actualState", access = JsonProperty.Access.WRITE_ONLY)
    private AutomaticTuningMode actualState;

    /**
     * Automatic tuning options definition.
     */
    @JsonProperty(value = "properties.options")
    private Map<String, AutomaticTuningOptions> options;

    /**
     * Get the desiredState value.
     *
     * @return the desiredState value
     */
    public AutomaticTuningMode desiredState() {
        return this.desiredState;
    }

    /**
     * Set the desiredState value.
     *
     * @param desiredState the desiredState value to set
     * @return the DatabaseAutomaticTuningInner object itself.
     */
    public DatabaseAutomaticTuningInner withDesiredState(AutomaticTuningMode desiredState) {
        this.desiredState = desiredState;
        return this;
    }

    /**
     * Get the actualState value.
     *
     * @return the actualState value
     */
    public AutomaticTuningMode actualState() {
        return this.actualState;
    }

    /**
     * Get the options value.
     *
     * @return the options value
     */
    public Map<String, AutomaticTuningOptions> options() {
        return this.options;
    }

    /**
     * Set the options value.
     *
     * @param options the options value to set
     * @return the DatabaseAutomaticTuningInner object itself.
     */
    public DatabaseAutomaticTuningInner withOptions(Map<String, AutomaticTuningOptions> options) {
        this.options = options;
        return this;
    }

}
