/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.GeoBackupPolicyState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * A database geo backup policy.
 */
@JsonFlatten
public class GeoBackupPolicyInner extends ProxyResourceInner {
    /**
     * The state of the geo backup policy. Possible values include: 'Disabled',
     * 'Enabled'.
     */
    @JsonProperty(value = "properties.state", required = true)
    private GeoBackupPolicyState state;

    /**
     * The storage type of the geo backup policy.
     */
    @JsonProperty(value = "properties.storageType", access = JsonProperty.Access.WRITE_ONLY)
    private String storageType;

    /**
     * Kind of geo backup policy.  This is metadata used for the Azure portal
     * experience.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /**
     * Backup policy location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * Get the state value.
     *
     * @return the state value
     */
    public GeoBackupPolicyState state() {
        return this.state;
    }

    /**
     * Set the state value.
     *
     * @param state the state value to set
     * @return the GeoBackupPolicyInner object itself.
     */
    public GeoBackupPolicyInner withState(GeoBackupPolicyState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the storageType value.
     *
     * @return the storageType value
     */
    public String storageType() {
        return this.storageType;
    }

    /**
     * Get the kind value.
     *
     * @return the kind value
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the location value.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

}
