/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.Sku;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * An update request for an Azure SQL Database managed instance.
 */
@JsonFlatten
public class ManagedInstanceUpdateInner {
    /**
     * Managed instance sku.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /**
     * The fully qualified domain name of the managed instance.
     */
    @JsonProperty(value = "properties.fullyQualifiedDomainName", access = JsonProperty.Access.WRITE_ONLY)
    private String fullyQualifiedDomainName;

    /**
     * Administrator username for the managed instance. Can only be specified
     * when the managed instance is being created (and is required for
     * creation).
     */
    @JsonProperty(value = "properties.administratorLogin")
    private String administratorLogin;

    /**
     * The administrator login password (required for managed instance
     * creation).
     */
    @JsonProperty(value = "properties.administratorLoginPassword")
    private String administratorLoginPassword;

    /**
     * Subnet resource ID for the managed instance.
     */
    @JsonProperty(value = "properties.subnetId")
    private String subnetId;

    /**
     * The state of the managed instance.
     */
    @JsonProperty(value = "properties.state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /**
     * The license type. Possible values are 'LicenseIncluded' and 'BasePrice'.
     */
    @JsonProperty(value = "properties.licenseType")
    private String licenseType;

    /**
     * The number of VCores.
     */
    @JsonProperty(value = "properties.vCores")
    private Integer vCores;

    /**
     * The maximum storage size in GB.
     */
    @JsonProperty(value = "properties.storageSizeInGB")
    private Integer storageSizeInGB;

    /**
     * Resource tags.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the fullyQualifiedDomainName value.
     *
     * @return the fullyQualifiedDomainName value
     */
    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    /**
     * Get the administratorLogin value.
     *
     * @return the administratorLogin value
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin value.
     *
     * @param administratorLogin the administratorLogin value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword value.
     *
     * @return the administratorLoginPassword value
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword value.
     *
     * @param administratorLoginPassword the administratorLoginPassword value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the subnetId value.
     *
     * @return the subnetId value
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Set the subnetId value.
     *
     * @param subnetId the subnetId value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Get the state value.
     *
     * @return the state value
     */
    public String state() {
        return this.state;
    }

    /**
     * Get the licenseType value.
     *
     * @return the licenseType value
     */
    public String licenseType() {
        return this.licenseType;
    }

    /**
     * Set the licenseType value.
     *
     * @param licenseType the licenseType value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    /**
     * Get the vCores value.
     *
     * @return the vCores value
     */
    public Integer vCores() {
        return this.vCores;
    }

    /**
     * Set the vCores value.
     *
     * @param vCores the vCores value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withVCores(Integer vCores) {
        this.vCores = vCores;
        return this;
    }

    /**
     * Get the storageSizeInGB value.
     *
     * @return the storageSizeInGB value
     */
    public Integer storageSizeInGB() {
        return this.storageSizeInGB;
    }

    /**
     * Set the storageSizeInGB value.
     *
     * @param storageSizeInGB the storageSizeInGB value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withStorageSizeInGB(Integer storageSizeInGB) {
        this.storageSizeInGB = storageSizeInGB;
        return this;
    }

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the ManagedInstanceUpdateInner object itself.
     */
    public ManagedInstanceUpdateInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

}
