/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import java.util.List;
import com.microsoft.azure.management.sql.SyncFullSchemaTable;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of the database full schema.
 */
public class SyncFullSchemaPropertiesInner {
    /**
     * List of tables in the database full schema.
     */
    @JsonProperty(value = "tables", access = JsonProperty.Access.WRITE_ONLY)
    private List<SyncFullSchemaTable> tables;

    /**
     * Last update time of the database schema.
     */
    @JsonProperty(value = "lastUpdateTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastUpdateTime;

    /**
     * Get the tables value.
     *
     * @return the tables value
     */
    public List<SyncFullSchemaTable> tables() {
        return this.tables;
    }

    /**
     * Get the lastUpdateTime value.
     *
     * @return the lastUpdateTime value
     */
    public DateTime lastUpdateTime() {
        return this.lastUpdateTime;
    }

}
