/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.ResourceMoveDefinition;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.DatabaseUpdateInner;
import com.microsoft.azure.management.sql.implementation.ExportRequestInner;
import com.microsoft.azure.management.sql.implementation.ImportExportResponseInner;
import com.microsoft.azure.management.sql.implementation.ImportExtensionRequestInner;
import com.microsoft.azure.management.sql.implementation.ImportRequestInner;
import com.microsoft.azure.management.sql.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.sql.implementation.MetricInner;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DatabasesInner {
    private DatabasesService service;
    private SqlManagementClientImpl client;

    public DatabasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (DatabasesService)retrofit.create(DatabasesService.class);
        this.client = client;
    }

    public void pause(String resourceGroupName, String serverName, String databaseName) {
        ((ServiceResponse)this.pauseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> pauseAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.pauseWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<Void> pauseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.pauseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> pauseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.pause(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginPause(String resourceGroupName, String serverName, String databaseName) {
        ((ServiceResponse)this.beginPauseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginPauseAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPauseWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<Void> beginPauseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.beginPauseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginPauseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.beginPause(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.beginPauseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginPauseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resume(String resourceGroupName, String serverName, String databaseName) {
        ((ServiceResponse)this.resumeWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> resumeAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resumeWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<Void> resumeAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.resumeWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resumeWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.resume(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginResume(String resourceGroupName, String serverName, String databaseName) {
        ((ServiceResponse)this.beginResumeWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginResumeAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginResumeWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<Void> beginResumeAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.beginResumeWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginResumeWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.beginResume(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.beginResumeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginResumeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters) {
        return (DatabaseInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseInner>(){}.getType());
    }

    public DatabaseInner beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters) {
        return (DatabaseInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, DatabaseInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2014-04-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseInner>>>(){

            public Observable<ServiceResponse<DatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseInner>(){}.getType()).register(201, new TypeToken<DatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseInner update(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters) {
        return (DatabaseInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseInner> updateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseInner> updateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseInner>(){}.getType());
    }

    public DatabaseInner beginUpdate(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters) {
        return (DatabaseInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, DatabaseUpdateInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2014-04-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseInner>>>(){

            public Observable<ServiceResponse<DatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String databaseName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseInner get(String resourceGroupName, String serverName, String databaseName) {
        return (DatabaseInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseInner> getAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<DatabaseInner> getAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        String expand = null;
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseInner>>>(){

            public Observable<ServiceResponse<DatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DatabaseInner get(String resourceGroupName, String serverName, String databaseName, String expand) {
        return (DatabaseInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseInner> getAsync(String resourceGroupName, String serverName, String databaseName, String expand, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, expand), serviceCallback);
    }

    public Observable<DatabaseInner> getAsync(String resourceGroupName, String serverName, String databaseName, String expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, expand).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String expand) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseInner>>>(){

            public Observable<ServiceResponse<DatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<DatabaseInner> listByServer(String resourceGroupName, String serverName) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<List<DatabaseInner>> listByServerAsync(String resourceGroupName, String serverName, ServiceCallback<List<DatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<List<DatabaseInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<List<DatabaseInner>>, List<DatabaseInner>>(){

            public List<DatabaseInner> call(ServiceResponse<List<DatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        String expand = null;
        String filter = null;
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", expand, filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabasesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<DatabaseInner> listByServer(String resourceGroupName, String serverName, String expand, String filter) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName, expand, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<DatabaseInner>> listByServerAsync(String resourceGroupName, String serverName, String expand, String filter, ServiceCallback<List<DatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName, expand, filter), serviceCallback);
    }

    public Observable<List<DatabaseInner>> listByServerAsync(String resourceGroupName, String serverName, String expand, String filter) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName, expand, filter).map((Func1)new Func1<ServiceResponse<List<DatabaseInner>>, List<DatabaseInner>>(){

            public List<DatabaseInner> call(ServiceResponse<List<DatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName, String expand, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", expand, filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabasesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseInner getByElasticPool(String resourceGroupName, String serverName, String elasticPoolName, String databaseName) {
        return (DatabaseInner)((Object)((ServiceResponse)this.getByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseInner> getByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName, String databaseName, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName, databaseName), serviceCallback);
    }

    public Observable<DatabaseInner> getByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName, String databaseName) {
        return this.getByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName, databaseName).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> getByElasticPoolWithServiceResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (elasticPoolName == null) {
            throw new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.getByElasticPool(this.client.subscriptionId(), resourceGroupName, serverName, elasticPoolName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseInner>>>(){

            public Observable<ServiceResponse<DatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.getByElasticPoolDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseInner> getByElasticPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<DatabaseInner> listByElasticPool(String resourceGroupName, String serverName, String elasticPoolName) {
        return (List)((ServiceResponse)this.listByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName).toBlocking().single()).body();
    }

    public ServiceFuture<List<DatabaseInner>> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName, ServiceCallback<List<DatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName), serviceCallback);
    }

    public Observable<List<DatabaseInner>> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.listByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName).map((Func1)new Func1<ServiceResponse<List<DatabaseInner>>, List<DatabaseInner>>(){

            public List<DatabaseInner> call(ServiceResponse<List<DatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseInner>>> listByElasticPoolWithServiceResponseAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (elasticPoolName == null) {
            throw new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByElasticPool(this.client.subscriptionId(), resourceGroupName, serverName, elasticPoolName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabasesInner.this.listByElasticPoolDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseInner>> listByElasticPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseInner getByRecommendedElasticPool(String resourceGroupName, String serverName, String recommendedElasticPoolName, String databaseName) {
        return (DatabaseInner)((Object)((ServiceResponse)this.getByRecommendedElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseInner> getByRecommendedElasticPoolAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, String databaseName, ServiceCallback<DatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByRecommendedElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName, databaseName), serviceCallback);
    }

    public Observable<DatabaseInner> getByRecommendedElasticPoolAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, String databaseName) {
        return this.getByRecommendedElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName, databaseName).map((Func1)new Func1<ServiceResponse<DatabaseInner>, DatabaseInner>(){

            public DatabaseInner call(ServiceResponse<DatabaseInner> response) {
                return (DatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseInner>> getByRecommendedElasticPoolWithServiceResponseAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (recommendedElasticPoolName == null) {
            throw new IllegalArgumentException("Parameter recommendedElasticPoolName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.getByRecommendedElasticPool(this.client.subscriptionId(), resourceGroupName, serverName, recommendedElasticPoolName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseInner>>>(){

            public Observable<ServiceResponse<DatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.getByRecommendedElasticPoolDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseInner> getByRecommendedElasticPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<DatabaseInner> listByRecommendedElasticPool(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        return (List)((ServiceResponse)this.listByRecommendedElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName).toBlocking().single()).body();
    }

    public ServiceFuture<List<DatabaseInner>> listByRecommendedElasticPoolAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, ServiceCallback<List<DatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByRecommendedElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName), serviceCallback);
    }

    public Observable<List<DatabaseInner>> listByRecommendedElasticPoolAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        return this.listByRecommendedElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, recommendedElasticPoolName).map((Func1)new Func1<ServiceResponse<List<DatabaseInner>>, List<DatabaseInner>>(){

            public List<DatabaseInner> call(ServiceResponse<List<DatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseInner>>> listByRecommendedElasticPoolWithServiceResponseAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (recommendedElasticPoolName == null) {
            throw new IllegalArgumentException("Parameter recommendedElasticPoolName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByRecommendedElasticPool(this.client.subscriptionId(), resourceGroupName, serverName, recommendedElasticPoolName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabasesInner.this.listByRecommendedElasticPoolDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseInner>> listByRecommendedElasticPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ImportExportResponseInner importMethod(String resourceGroupName, String serverName, ImportRequestInner parameters) {
        return (ImportExportResponseInner)((ServiceResponse)this.importMethodWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<ImportExportResponseInner> importMethodAsync(String resourceGroupName, String serverName, ImportRequestInner parameters, ServiceCallback<ImportExportResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.importMethodWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ImportExportResponseInner> importMethodAsync(String resourceGroupName, String serverName, ImportRequestInner parameters) {
        return this.importMethodWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ImportExportResponseInner>, ImportExportResponseInner>(){

            public ImportExportResponseInner call(ServiceResponse<ImportExportResponseInner> response) {
                return (ImportExportResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImportExportResponseInner>> importMethodWithServiceResponseAsync(String resourceGroupName, String serverName, ImportRequestInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.importMethod(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ImportExportResponseInner>(){}.getType());
    }

    public ImportExportResponseInner beginImportMethod(String resourceGroupName, String serverName, ImportRequestInner parameters) {
        return (ImportExportResponseInner)((ServiceResponse)this.beginImportMethodWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ImportExportResponseInner> beginImportMethodAsync(String resourceGroupName, String serverName, ImportRequestInner parameters, ServiceCallback<ImportExportResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginImportMethodWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ImportExportResponseInner> beginImportMethodAsync(String resourceGroupName, String serverName, ImportRequestInner parameters) {
        return this.beginImportMethodWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ImportExportResponseInner>, ImportExportResponseInner>(){

            public ImportExportResponseInner call(ServiceResponse<ImportExportResponseInner> response) {
                return (ImportExportResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImportExportResponseInner>> beginImportMethodWithServiceResponseAsync(String resourceGroupName, String serverName, ImportRequestInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2014-04-01";
        return this.service.beginImportMethod(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImportExportResponseInner>>>(){

            public Observable<ServiceResponse<ImportExportResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.beginImportMethodDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImportExportResponseInner> beginImportMethodDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImportExportResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ImportExportResponseInner createImportOperation(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters) {
        return (ImportExportResponseInner)((ServiceResponse)this.createImportOperationWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<ImportExportResponseInner> createImportOperationAsync(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters, ServiceCallback<ImportExportResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createImportOperationWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<ImportExportResponseInner> createImportOperationAsync(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters) {
        return this.createImportOperationWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ImportExportResponseInner>, ImportExportResponseInner>(){

            public ImportExportResponseInner call(ServiceResponse<ImportExportResponseInner> response) {
                return (ImportExportResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImportExportResponseInner>> createImportOperationWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String extensionName = "import";
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.createImportOperation(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "import", "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ImportExportResponseInner>(){}.getType());
    }

    public ImportExportResponseInner beginCreateImportOperation(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters) {
        return (ImportExportResponseInner)((ServiceResponse)this.beginCreateImportOperationWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ImportExportResponseInner> beginCreateImportOperationAsync(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters, ServiceCallback<ImportExportResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateImportOperationWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<ImportExportResponseInner> beginCreateImportOperationAsync(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters) {
        return this.beginCreateImportOperationWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ImportExportResponseInner>, ImportExportResponseInner>(){

            public ImportExportResponseInner call(ServiceResponse<ImportExportResponseInner> response) {
                return (ImportExportResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImportExportResponseInner>> beginCreateImportOperationWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, ImportExtensionRequestInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String extensionName = "import";
        String apiVersion = "2014-04-01";
        return this.service.beginCreateImportOperation(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "import", "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImportExportResponseInner>>>(){

            public Observable<ServiceResponse<ImportExportResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.beginCreateImportOperationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImportExportResponseInner> beginCreateImportOperationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<ImportExportResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ImportExportResponseInner export(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters) {
        return (ImportExportResponseInner)((ServiceResponse)this.exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<ImportExportResponseInner> exportAsync(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters, ServiceCallback<ImportExportResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<ImportExportResponseInner> exportAsync(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters) {
        return this.exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ImportExportResponseInner>, ImportExportResponseInner>(){

            public ImportExportResponseInner call(ServiceResponse<ImportExportResponseInner> response) {
                return (ImportExportResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImportExportResponseInner>> exportWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.export(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ImportExportResponseInner>(){}.getType());
    }

    public ImportExportResponseInner beginExport(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters) {
        return (ImportExportResponseInner)((ServiceResponse)this.beginExportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ImportExportResponseInner> beginExportAsync(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters, ServiceCallback<ImportExportResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginExportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<ImportExportResponseInner> beginExportAsync(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters) {
        return this.beginExportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ImportExportResponseInner>, ImportExportResponseInner>(){

            public ImportExportResponseInner call(ServiceResponse<ImportExportResponseInner> response) {
                return (ImportExportResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImportExportResponseInner>> beginExportWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, ExportRequestInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2014-04-01";
        return this.service.beginExport(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImportExportResponseInner>>>(){

            public Observable<ServiceResponse<ImportExportResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.beginExportDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImportExportResponseInner> beginExportDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImportExportResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MetricInner> listMetrics(String resourceGroupName, String serverName, String databaseName, String filter) {
        return (List)((ServiceResponse)this.listMetricsWithServiceResponseAsync(resourceGroupName, serverName, databaseName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricInner>> listMetricsAsync(String resourceGroupName, String serverName, String databaseName, String filter, ServiceCallback<List<MetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricsWithServiceResponseAsync(resourceGroupName, serverName, databaseName, filter), serviceCallback);
    }

    public Observable<List<MetricInner>> listMetricsAsync(String resourceGroupName, String serverName, String databaseName, String filter) {
        return this.listMetricsWithServiceResponseAsync(resourceGroupName, serverName, databaseName, filter).map((Func1)new Func1<ServiceResponse<List<MetricInner>>, List<MetricInner>>(){

            public List<MetricInner> call(ServiceResponse<List<MetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listMetrics(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricInner>>>>(){

            public Observable<ServiceResponse<List<MetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabasesInner.this.listMetricsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String serverName, String databaseName) {
        return (List)((ServiceResponse)this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>(){

            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listMetricDefinitionsWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listMetricDefinitions(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>(){

            public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabasesInner.this.listMetricDefinitionsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricDefinitionInner>> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void rename(String resourceGroupName, String serverName, String databaseName, String id) {
        ((ServiceResponse)this.renameWithServiceResponseAsync(resourceGroupName, serverName, databaseName, id).toBlocking().single()).body();
    }

    public ServiceFuture<Void> renameAsync(String resourceGroupName, String serverName, String databaseName, String id, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.renameWithServiceResponseAsync(resourceGroupName, serverName, databaseName, id), serviceCallback);
    }

    public Observable<Void> renameAsync(String resourceGroupName, String serverName, String databaseName, String id) {
        return this.renameWithServiceResponseAsync(resourceGroupName, serverName, databaseName, id).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> renameWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String id) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        ResourceMoveDefinition parameters = new ResourceMoveDefinition();
        parameters.withId(id);
        return this.service.rename(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabasesInner.this.renameDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> renameDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabasesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases pause"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/pause")
        public Observable<Response<ResponseBody>> pause(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases beginPause"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/pause")
        public Observable<Response<ResponseBody>> beginPause(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases resume"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/resume")
        public Observable<Response<ResponseBody>> resume(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases beginResume"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/resume")
        public Observable<Response<ResponseBody>> beginResume(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body DatabaseInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body DatabaseInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body DatabaseUpdateInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body DatabaseUpdateInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Query(value="$expand") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Query(value="$filter") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases getByElasticPool"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> getByElasticPool(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="elasticPoolName") String var4, @Path(value="databaseName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases listByElasticPool"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/databases")
        public Observable<Response<ResponseBody>> listByElasticPool(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="elasticPoolName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases getByRecommendedElasticPool"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> getByRecommendedElasticPool(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="recommendedElasticPoolName") String var4, @Path(value="databaseName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases listByRecommendedElasticPool"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/databases")
        public Observable<Response<ResponseBody>> listByRecommendedElasticPool(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="recommendedElasticPoolName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases importMethod"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/import")
        public Observable<Response<ResponseBody>> importMethod(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Body ImportRequestInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases beginImportMethod"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/import")
        public Observable<Response<ResponseBody>> beginImportMethod(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Body ImportRequestInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases createImportOperation"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/extensions/{extensionName}")
        public Observable<Response<ResponseBody>> createImportOperation(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="extensionName") String var5, @Query(value="api-version") String var6, @Body ImportExtensionRequestInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases beginCreateImportOperation"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/extensions/{extensionName}")
        public Observable<Response<ResponseBody>> beginCreateImportOperation(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="extensionName") String var5, @Query(value="api-version") String var6, @Body ImportExtensionRequestInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases export"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/export")
        public Observable<Response<ResponseBody>> export(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ExportRequestInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases beginExport"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/export")
        public Observable<Response<ResponseBody>> beginExport(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ExportRequestInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases listMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/metrics")
        public Observable<Response<ResponseBody>> listMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Query(value="$filter") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases listMetricDefinitions"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/metricDefinitions")
        public Observable<Response<ResponseBody>> listMetricDefinitions(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Databases rename"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/move")
        public Observable<Response<ResponseBody>> rename(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ResourceMoveDefinition var7, @Header(value="User-Agent") String var8);
    }
}

