/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import org.joda.time.DateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * Represents the activity on an elastic pool.
 */
@JsonFlatten
public class ElasticPoolDatabaseActivityInner extends ProxyResource {
    /**
     * The geo-location where the resource lives.
     */
    @JsonProperty(value = "location")
    private String location;

    /**
     * The database name.
     */
    @JsonProperty(value = "properties.databaseName", access = JsonProperty.Access.WRITE_ONLY)
    private String databaseName;

    /**
     * The time the operation finished (ISO8601 format).
     */
    @JsonProperty(value = "properties.endTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime endTime;

    /**
     * The error code if available.
     */
    @JsonProperty(value = "properties.errorCode", access = JsonProperty.Access.WRITE_ONLY)
    private Integer errorCode;

    /**
     * The error message if available.
     */
    @JsonProperty(value = "properties.errorMessage", access = JsonProperty.Access.WRITE_ONLY)
    private String errorMessage;

    /**
     * The error severity if available.
     */
    @JsonProperty(value = "properties.errorSeverity", access = JsonProperty.Access.WRITE_ONLY)
    private Integer errorSeverity;

    /**
     * The operation name.
     */
    @JsonProperty(value = "properties.operation", access = JsonProperty.Access.WRITE_ONLY)
    private String operation;

    /**
     * The unique operation ID.
     */
    @JsonProperty(value = "properties.operationId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID operationId;

    /**
     * The percentage complete if available.
     */
    @JsonProperty(value = "properties.percentComplete", access = JsonProperty.Access.WRITE_ONLY)
    private Integer percentComplete;

    /**
     * The name for the elastic pool the database is moving into if available.
     */
    @JsonProperty(value = "properties.requestedElasticPoolName", access = JsonProperty.Access.WRITE_ONLY)
    private String requestedElasticPoolName;

    /**
     * The name of the current elastic pool the database is in if available.
     */
    @JsonProperty(value = "properties.currentElasticPoolName", access = JsonProperty.Access.WRITE_ONLY)
    private String currentElasticPoolName;

    /**
     * The name of the current service objective if available.
     */
    @JsonProperty(value = "properties.currentServiceObjective", access = JsonProperty.Access.WRITE_ONLY)
    private String currentServiceObjective;

    /**
     * The name of the requested service objective if available.
     */
    @JsonProperty(value = "properties.requestedServiceObjective", access = JsonProperty.Access.WRITE_ONLY)
    private String requestedServiceObjective;

    /**
     * The name of the server the elastic pool is in.
     */
    @JsonProperty(value = "properties.serverName", access = JsonProperty.Access.WRITE_ONLY)
    private String serverName;

    /**
     * The time the operation started (ISO8601 format).
     */
    @JsonProperty(value = "properties.startTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime startTime;

    /**
     * The current state of the operation.
     */
    @JsonProperty(value = "properties.state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /**
     * Get the geo-location where the resource lives.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the geo-location where the resource lives.
     *
     * @param location the location value to set
     * @return the ElasticPoolDatabaseActivityInner object itself.
     */
    public ElasticPoolDatabaseActivityInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the database name.
     *
     * @return the databaseName value
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Get the time the operation finished (ISO8601 format).
     *
     * @return the endTime value
     */
    public DateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the error code if available.
     *
     * @return the errorCode value
     */
    public Integer errorCode() {
        return this.errorCode;
    }

    /**
     * Get the error message if available.
     *
     * @return the errorMessage value
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Get the error severity if available.
     *
     * @return the errorSeverity value
     */
    public Integer errorSeverity() {
        return this.errorSeverity;
    }

    /**
     * Get the operation name.
     *
     * @return the operation value
     */
    public String operation() {
        return this.operation;
    }

    /**
     * Get the unique operation ID.
     *
     * @return the operationId value
     */
    public UUID operationId() {
        return this.operationId;
    }

    /**
     * Get the percentage complete if available.
     *
     * @return the percentComplete value
     */
    public Integer percentComplete() {
        return this.percentComplete;
    }

    /**
     * Get the name for the elastic pool the database is moving into if available.
     *
     * @return the requestedElasticPoolName value
     */
    public String requestedElasticPoolName() {
        return this.requestedElasticPoolName;
    }

    /**
     * Get the name of the current elastic pool the database is in if available.
     *
     * @return the currentElasticPoolName value
     */
    public String currentElasticPoolName() {
        return this.currentElasticPoolName;
    }

    /**
     * Get the name of the current service objective if available.
     *
     * @return the currentServiceObjective value
     */
    public String currentServiceObjective() {
        return this.currentServiceObjective;
    }

    /**
     * Get the name of the requested service objective if available.
     *
     * @return the requestedServiceObjective value
     */
    public String requestedServiceObjective() {
        return this.requestedServiceObjective;
    }

    /**
     * Get the name of the server the elastic pool is in.
     *
     * @return the serverName value
     */
    public String serverName() {
        return this.serverName;
    }

    /**
     * Get the time the operation started (ISO8601 format).
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the current state of the operation.
     *
     * @return the state value
     */
    public String state() {
        return this.state;
    }

}
