/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in JobExecutions.
 */
public class JobExecutionsInner {
    /** The Retrofit service to perform REST calls. */
    private JobExecutionsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of JobExecutionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public JobExecutionsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(JobExecutionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for JobExecutions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface JobExecutionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByAgent" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/executions")
        Observable<Response<ResponseBody>> listByAgent(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("subscriptionId") String subscriptionId, @Query("createTimeMin") DateTime createTimeMin, @Query("createTimeMax") DateTime createTimeMax, @Query("endTimeMin") DateTime endTimeMin, @Query("endTimeMax") DateTime endTimeMax, @Query("isActive") Boolean isActive, @Query("$skip") Integer skip, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions cancel" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/cancel")
        Observable<Response<ResponseBody>> cancel(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("jobExecutionId") UUID jobExecutionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions create" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/start")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions beginCreate" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/start")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByJob" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions")
        Observable<Response<ResponseBody>> listByJob(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("createTimeMin") DateTime createTimeMin, @Query("createTimeMax") DateTime createTimeMax, @Query("endTimeMin") DateTime endTimeMin, @Query("endTimeMax") DateTime endTimeMax, @Query("isActive") Boolean isActive, @Query("$skip") Integer skip, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("jobExecutionId") UUID jobExecutionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("jobExecutionId") UUID jobExecutionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("jobName") String jobName, @Path("jobExecutionId") UUID jobExecutionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByAgentNext" })
        @GET
        Observable<Response<ResponseBody>> listByAgentNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByJobNext" })
        @GET
        Observable<Response<ResponseBody>> listByJobNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByAgent(final String resourceGroupName, final String serverName, final String jobAgentName) {
        ServiceResponse<Page<JobExecutionInner>> response = listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByAgentAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByAgentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByAgentAsync(final String resourceGroupName, final String serverName, final String jobAgentName) {
        return listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName) {
        return listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByAgentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        final DateTime createTimeMin = null;
        final DateTime createTimeMax = null;
        final DateTime endTimeMin = null;
        final DateTime endTimeMax = null;
        final Boolean isActive = null;
        final Integer skip = null;
        final Integer top = null;
        return service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByAgentDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByAgent(final String resourceGroupName, final String serverName, final String jobAgentName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        ServiceResponse<Page<JobExecutionInner>> response = listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByAgentAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByAgentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByAgentAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByAgentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all executions in a job agent.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobAgentName The name of the job agent.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMin If specified, only job executions created at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMax If specified, only job executions created before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMax If specified, only job executions completed before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param isActive If specified, only active or only completed job executions are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param skip The number of elements in the collection to skip.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByAgentDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByAgentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Requests cancellation of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution to cancel.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancel(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        cancelWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single().body();
    }

    /**
     * Requests cancellation of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution to cancel.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    /**
     * Requests cancellation of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution to cancel.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> cancelAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return cancelWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Requests cancellation of a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution to cancel.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.cancel(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = cancelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> cancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobExecutionInner object if successful.
     */
    public JobExecutionInner create(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return createWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().last().body();
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, final ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName), serviceCallback);
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return createWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map(new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>() {
            @Override
            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<JobExecutionInner>> createWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<JobExecutionInner>() { }.getType());
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobExecutionInner object if successful.
     */
    public JobExecutionInner beginCreate(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single().body();
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, final ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName), serviceCallback);
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map(new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>() {
            @Override
            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Starts an elastic job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<ServiceResponse<JobExecutionInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.beginCreate(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>() {
                @Override
                public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobExecutionInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobExecutionInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobExecutionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobExecutionInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByJob(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName) {
        ServiceResponse<Page<JobExecutionInner>> response = listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByJobNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByJobAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByJobNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByJobAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName) {
        return listByJobWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName) {
        return listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByJobNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        final DateTime createTimeMin = null;
        final DateTime createTimeMax = null;
        final DateTime endTimeMin = null;
        final DateTime endTimeMax = null;
        final Boolean isActive = null;
        final Integer skip = null;
        final Integer top = null;
        return service.listByJob(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByJobDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByJob(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        ServiceResponse<Page<JobExecutionInner>> response = listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByJobNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByJobAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByJobNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByJobAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByJobWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists a job's executions.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param createTimeMin If specified, only job executions created at or after the specified time are included.
     * @param createTimeMax If specified, only job executions created before the specified time are included.
     * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
     * @param endTimeMax If specified, only job executions completed before the specified time are included.
     * @param isActive If specified, only active or only completed job executions are included.
     * @param skip The number of elements in the collection to skip.
     * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        return listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByJobNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists a job's executions.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobAgentName The name of the job agent.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param jobName The name of the job to get.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMin If specified, only job executions created at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param createTimeMax If specified, only job executions created before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMin If specified, only job executions completed at or after the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param endTimeMax If specified, only job executions completed before the specified time are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param isActive If specified, only active or only completed job executions are included.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param skip The number of elements in the collection to skip.
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param top The number of elements to return from the collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final String jobName, final DateTime createTimeMin, final DateTime createTimeMax, final DateTime endTimeMin, final DateTime endTimeMax, final Boolean isActive, final Integer skip, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByJob(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByJobDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobExecutionInner object if successful.
     */
    public JobExecutionInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single().body();
    }

    /**
     * Gets a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, final ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    /**
     * Gets a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map(new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>() {
            @Override
            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param jobExecutionId The id of the job execution
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<ServiceResponse<JobExecutionInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.get(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>() {
                @Override
                public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobExecutionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobExecutionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobExecutionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobExecutionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobExecutionInner object if successful.
     */
    public JobExecutionInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().last().body();
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, final ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map(new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>() {
            @Override
            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<JobExecutionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobExecutionInner>() { }.getType());
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobExecutionInner object if successful.
     */
    public JobExecutionInner beginCreateOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single().body();
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, final ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map(new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>() {
            @Override
            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a job execution.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param jobExecutionId The job execution id to create the job execution under.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobExecutionInner object
     */
    public Observable<ServiceResponse<JobExecutionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.beginCreateOrUpdate(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>() {
                @Override
                public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobExecutionInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobExecutionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobExecutionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobExecutionInner>() { }.getType())
                .register(201, new TypeToken<JobExecutionInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByAgentNext(final String nextPageLink) {
        ServiceResponse<Page<JobExecutionInner>> response = listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByAgentNextAsync(final String nextPageLink, final ServiceFuture<List<JobExecutionInner>> serviceFuture, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByAgentNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByAgentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByAgentNextAsync(final String nextPageLink) {
        return listByAgentNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all executions in a job agent.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentNextWithServiceResponseAsync(final String nextPageLink) {
        return listByAgentNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByAgentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all executions in a job agent.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByAgentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByAgentNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByAgentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists a job's executions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobExecutionInner&gt; object if successful.
     */
    public PagedList<JobExecutionInner> listByJobNext(final String nextPageLink) {
        ServiceResponse<Page<JobExecutionInner>> response = listByJobNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>(response.body()) {
            @Override
            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return listByJobNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists a job's executions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobExecutionInner>> listByJobNextAsync(final String nextPageLink, final ServiceFuture<List<JobExecutionInner>> serviceFuture, final ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByJobNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                    return listByJobNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists a job's executions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<Page<JobExecutionInner>> listByJobNextAsync(final String nextPageLink) {
        return listByJobNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>() {
                @Override
                public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists a job's executions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobExecutionInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobNextWithServiceResponseAsync(final String nextPageLink) {
        return listByJobNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByJobNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists a job's executions.
     *
    ServiceResponse<PageImpl1<JobExecutionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobExecutionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByJobNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobExecutionInner>> result = listByJobNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobExecutionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobExecutionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobExecutionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
