/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import org.joda.time.DateTime;
import com.microsoft.azure.management.sql.SyncGroupLogType;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of an Azure SQL Database sync group log.
 */
public class SyncGroupLogPropertiesInner {
    /**
     * Timestamp of the sync group log.
     */
    @JsonProperty(value = "timestamp", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime timestamp;

    /**
     * Type of the sync group log. Possible values include: 'All', 'Error',
     * 'Warning', 'Success'.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private SyncGroupLogType type;

    /**
     * Source of the sync group log.
     */
    @JsonProperty(value = "source", access = JsonProperty.Access.WRITE_ONLY)
    private String source;

    /**
     * Details of the sync group log.
     */
    @JsonProperty(value = "details", access = JsonProperty.Access.WRITE_ONLY)
    private String details;

    /**
     * TracingId of the sync group log.
     */
    @JsonProperty(value = "tracingId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID tracingId;

    /**
     * OperationStatus of the sync group log.
     */
    @JsonProperty(value = "operationStatus", access = JsonProperty.Access.WRITE_ONLY)
    private String operationStatus;

    /**
     * Get timestamp of the sync group log.
     *
     * @return the timestamp value
     */
    public DateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get type of the sync group log. Possible values include: 'All', 'Error', 'Warning', 'Success'.
     *
     * @return the type value
     */
    public SyncGroupLogType type() {
        return this.type;
    }

    /**
     * Get source of the sync group log.
     *
     * @return the source value
     */
    public String source() {
        return this.source;
    }

    /**
     * Get details of the sync group log.
     *
     * @return the details value
     */
    public String details() {
        return this.details;
    }

    /**
     * Get tracingId of the sync group log.
     *
     * @return the tracingId value
     */
    public UUID tracingId() {
        return this.tracingId;
    }

    /**
     * Get operationStatus of the sync group log.
     *
     * @return the operationStatus value
     */
    public String operationStatus() {
        return this.operationStatus;
    }

}
