/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in SyncMembers.
 */
public class SyncMembersInner {
    /** The Retrofit service to perform REST calls. */
    private SyncMembersService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of SyncMembersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public SyncMembersInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(SyncMembersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for SyncMembers to be
     * used by Retrofit to perform actually REST calls.
     */
    interface SyncMembersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Body SyncMemberInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Body SyncMemberInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Body SyncMemberInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Body SyncMemberInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listBySyncGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers")
        Observable<Response<ResponseBody>> listBySyncGroup(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listMemberSchemas" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/schemas")
        Observable<Response<ResponseBody>> listMemberSchemas(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers refreshMemberSchema" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/refreshSchema")
        Observable<Response<ResponseBody>> refreshMemberSchema(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers beginRefreshMemberSchema" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/refreshSchema")
        Observable<Response<ResponseBody>> beginRefreshMemberSchema(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("syncGroupName") String syncGroupName, @Path("syncMemberName") String syncMemberName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listBySyncGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listBySyncGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncMembers listMemberSchemasNext" })
        @GET
        Observable<Response<ResponseBody>> listMemberSchemasNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SyncMemberInner object if successful.
     */
    public SyncMemberInner get(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single().body();
    }

    /**
     * Gets a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SyncMemberInner> getAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, final ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    /**
     * Gets a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SyncMemberInner object
     */
    public Observable<SyncMemberInner> getAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map(new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>() {
            @Override
            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SyncMemberInner object
     */
    public Observable<ServiceResponse<SyncMemberInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.get(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncMemberInner>>>() {
                @Override
                public Observable<ServiceResponse<SyncMemberInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SyncMemberInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SyncMemberInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SyncMemberInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SyncMemberInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SyncMemberInner object if successful.
     */
    public SyncMemberInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SyncMemberInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, final ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SyncMemberInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map(new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>() {
            @Override
            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SyncMemberInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncMemberInner>() { }.getType());
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SyncMemberInner object if successful.
     */
    public SyncMemberInner beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SyncMemberInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, final ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SyncMemberInner object
     */
    public Observable<SyncMemberInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map(new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>() {
            @Override
            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SyncMemberInner object
     */
    public Observable<ServiceResponse<SyncMemberInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        return service.beginCreateOrUpdate(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncMemberInner>>>() {
                @Override
                public Observable<ServiceResponse<SyncMemberInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SyncMemberInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SyncMemberInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SyncMemberInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SyncMemberInner>() { }.getType())
                .register(201, new TypeToken<SyncMemberInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().last().body();
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single().body();
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.beginDelete(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SyncMemberInner object if successful.
     */
    public SyncMemberInner update(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().last().body();
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SyncMemberInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, final ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SyncMemberInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map(new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>() {
            @Override
            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SyncMemberInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncMemberInner>() { }.getType());
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SyncMemberInner object if successful.
     */
    public SyncMemberInner beginUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).toBlocking().single().body();
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SyncMemberInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, final ServiceCallback<SyncMemberInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters), serviceCallback);
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SyncMemberInner object
     */
    public Observable<SyncMemberInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).map(new Func1<ServiceResponse<SyncMemberInner>, SyncMemberInner>() {
            @Override
            public SyncMemberInner call(ServiceResponse<SyncMemberInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing sync member.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param parameters The requested sync member resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SyncMemberInner object
     */
    public Observable<ServiceResponse<SyncMemberInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        return service.beginUpdate(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncMemberInner>>>() {
                @Override
                public Observable<ServiceResponse<SyncMemberInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SyncMemberInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SyncMemberInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SyncMemberInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SyncMemberInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SyncMemberInner&gt; object if successful.
     */
    public PagedList<SyncMemberInner> listBySyncGroup(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName) {
        ServiceResponse<Page<SyncMemberInner>> response = listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single();
        return new PagedList<SyncMemberInner>(response.body()) {
            @Override
            public Page<SyncMemberInner> nextPage(String nextPageLink) {
                return listBySyncGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SyncMemberInner>> listBySyncGroupAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName, final ListOperationCallback<SyncMemberInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName),
            new Func1<String, Observable<ServiceResponse<Page<SyncMemberInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncMemberInner>>> call(String nextPageLink) {
                    return listBySyncGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncMemberInner&gt; object
     */
    public Observable<Page<SyncMemberInner>> listBySyncGroupAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName) {
        return listBySyncGroupWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName)
            .map(new Func1<ServiceResponse<Page<SyncMemberInner>>, Page<SyncMemberInner>>() {
                @Override
                public Page<SyncMemberInner> call(ServiceResponse<Page<SyncMemberInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncMemberInner&gt; object
     */
    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName) {
        return listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName)
            .concatMap(new Func1<ServiceResponse<Page<SyncMemberInner>>, Observable<ServiceResponse<Page<SyncMemberInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncMemberInner>>> call(ServiceResponse<Page<SyncMemberInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySyncGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists sync members in the given sync group.
     *
    ServiceResponse<PageImpl1<SyncMemberInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<SyncMemberInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<SyncMemberInner>> * @param databaseName The name of the database on which the sync group is hosted.
    ServiceResponse<PageImpl1<SyncMemberInner>> * @param syncGroupName The name of the sync group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SyncMemberInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupSinglePageAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.listBySyncGroup(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncMemberInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncMemberInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SyncMemberInner>> result = listBySyncGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SyncMemberInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SyncMemberInner>> listBySyncGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SyncMemberInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SyncMemberInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object if successful.
     */
    public PagedList<SyncFullSchemaPropertiesInner> listMemberSchemas(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName, final String syncMemberName) {
        ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response = listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single();
        return new PagedList<SyncFullSchemaPropertiesInner>(response.body()) {
            @Override
            public Page<SyncFullSchemaPropertiesInner> nextPage(String nextPageLink) {
                return listMemberSchemasNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SyncFullSchemaPropertiesInner>> listMemberSchemasAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName, final String syncMemberName, final ListOperationCallback<SyncFullSchemaPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName),
            new Func1<String, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(String nextPageLink) {
                    return listMemberSchemasNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object
     */
    public Observable<Page<SyncFullSchemaPropertiesInner>> listMemberSchemasAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName, final String syncMemberName) {
        return listMemberSchemasWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName)
            .map(new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Page<SyncFullSchemaPropertiesInner>>() {
                @Override
                public Page<SyncFullSchemaPropertiesInner> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object
     */
    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName, final String syncMemberName) {
        return listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName)
            .concatMap(new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMemberSchemasNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a sync member database schema.
     *
    ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> * @param databaseName The name of the database on which the sync group is hosted.
    ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> * @param syncGroupName The name of the sync group on which the sync member is hosted.
    ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasSinglePageAsync(final String resourceGroupName, final String serverName, final String databaseName, final String syncGroupName, final String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.listMemberSchemas(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> result = listMemberSchemasDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SyncFullSchemaPropertiesInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> listMemberSchemasDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SyncFullSchemaPropertiesInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SyncFullSchemaPropertiesInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void refreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        refreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().last().body();
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> refreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(refreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> refreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return refreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> refreshMemberSchemaWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.refreshMemberSchema(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginRefreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        beginRefreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).toBlocking().single().body();
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginRefreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginRefreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), serviceCallback);
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginRefreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return beginRefreshMemberSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Refreshes a sync member database schema.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginRefreshMemberSchemaWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (syncMemberName == null) {
            throw new IllegalArgumentException("Parameter syncMemberName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.beginRefreshMemberSchema(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginRefreshMemberSchemaDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginRefreshMemberSchemaDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SyncMemberInner&gt; object if successful.
     */
    public PagedList<SyncMemberInner> listBySyncGroupNext(final String nextPageLink) {
        ServiceResponse<Page<SyncMemberInner>> response = listBySyncGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncMemberInner>(response.body()) {
            @Override
            public Page<SyncMemberInner> nextPage(String nextPageLink) {
                return listBySyncGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SyncMemberInner>> listBySyncGroupNextAsync(final String nextPageLink, final ServiceFuture<List<SyncMemberInner>> serviceFuture, final ListOperationCallback<SyncMemberInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySyncGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SyncMemberInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncMemberInner>>> call(String nextPageLink) {
                    return listBySyncGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncMemberInner&gt; object
     */
    public Observable<Page<SyncMemberInner>> listBySyncGroupNextAsync(final String nextPageLink) {
        return listBySyncGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SyncMemberInner>>, Page<SyncMemberInner>>() {
                @Override
                public Page<SyncMemberInner> call(ServiceResponse<Page<SyncMemberInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists sync members in the given sync group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncMemberInner&gt; object
     */
    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listBySyncGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SyncMemberInner>>, Observable<ServiceResponse<Page<SyncMemberInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncMemberInner>>> call(ServiceResponse<Page<SyncMemberInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySyncGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists sync members in the given sync group.
     *
    ServiceResponse<PageImpl1<SyncMemberInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SyncMemberInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SyncMemberInner>>> listBySyncGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBySyncGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncMemberInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncMemberInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SyncMemberInner>> result = listBySyncGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SyncMemberInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SyncMemberInner>> listBySyncGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SyncMemberInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SyncMemberInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a sync member database schema.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object if successful.
     */
    public PagedList<SyncFullSchemaPropertiesInner> listMemberSchemasNext(final String nextPageLink) {
        ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response = listMemberSchemasNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncFullSchemaPropertiesInner>(response.body()) {
            @Override
            public Page<SyncFullSchemaPropertiesInner> nextPage(String nextPageLink) {
                return listMemberSchemasNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a sync member database schema.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SyncFullSchemaPropertiesInner>> listMemberSchemasNextAsync(final String nextPageLink, final ServiceFuture<List<SyncFullSchemaPropertiesInner>> serviceFuture, final ListOperationCallback<SyncFullSchemaPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMemberSchemasNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(String nextPageLink) {
                    return listMemberSchemasNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a sync member database schema.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object
     */
    public Observable<Page<SyncFullSchemaPropertiesInner>> listMemberSchemasNextAsync(final String nextPageLink) {
        return listMemberSchemasNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Page<SyncFullSchemaPropertiesInner>>() {
                @Override
                public Page<SyncFullSchemaPropertiesInner> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a sync member database schema.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object
     */
    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasNextWithServiceResponseAsync(final String nextPageLink) {
        return listMemberSchemasNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMemberSchemasNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a sync member database schema.
     *
    ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SyncFullSchemaPropertiesInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listMemberSchemasNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMemberSchemasNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> result = listMemberSchemasNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SyncFullSchemaPropertiesInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> listMemberSchemasNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SyncFullSchemaPropertiesInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SyncFullSchemaPropertiesInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
