/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.JobExecutionInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobExecutionsInner {
    private JobExecutionsService service;
    private SqlManagementClientImpl client;

    public JobExecutionsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobExecutionsService)retrofit.create(JobExecutionsService.class);
        this.client = client;
    }

    public PagedList<JobExecutionInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName) {
        ServiceResponse response = (ServiceResponse)this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobExecutionsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobExecutionsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobExecutionsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        DateTime createTimeMin = null;
        DateTime createTimeMax = null;
        DateTime endTimeMin = null;
        DateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return this.service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobExecutionsInner.this.listByAgentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<JobExecutionInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobExecutionsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobExecutionsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobExecutionsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobExecutionsInner.this.listByAgentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByAgentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancel(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        ((ServiceResponse)this.cancelWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    public Observable<Void> cancelAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.cancelWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.cancel(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobExecutionsInner.this.cancelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobExecutionInner create(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return (JobExecutionInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().last()).body());
    }

    public ServiceFuture<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName), serviceCallback);
    }

    public Observable<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.createWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map((Func1)new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>(){

            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return (JobExecutionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobExecutionInner>> createWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<JobExecutionInner>(){}.getType());
    }

    public JobExecutionInner beginCreate(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return (JobExecutionInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single()).body());
    }

    public ServiceFuture<JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName), serviceCallback);
    }

    public Observable<JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map((Func1)new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>(){

            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return (JobExecutionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobExecutionInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreate(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>(){

            public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobExecutionsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobExecutionInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobExecutionInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobExecutionInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        ServiceResponse response = (ServiceResponse)this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobExecutionsInner.this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobExecutionsInner.this.listByJobNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.listByJobWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobExecutionsInner.this.listByJobNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        DateTime createTimeMin = null;
        DateTime createTimeMax = null;
        DateTime endTimeMin = null;
        DateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return this.service.listByJob(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobExecutionsInner.this.listByJobDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<JobExecutionInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobExecutionsInner.this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobExecutionsInner.this.listByJobNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByJobWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobExecutionsInner.this.listByJobNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByJob(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobExecutionsInner.this.listByJobDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobExecutionInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return (JobExecutionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single()).body());
    }

    public ServiceFuture<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    public Observable<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map((Func1)new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>(){

            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return (JobExecutionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobExecutionInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>(){

            public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobExecutionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobExecutionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobExecutionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobExecutionInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return (JobExecutionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().last()).body());
    }

    public ServiceFuture<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    public Observable<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map((Func1)new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>(){

            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return (JobExecutionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobExecutionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobExecutionInner>(){}.getType());
    }

    public JobExecutionInner beginCreateOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return (JobExecutionInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single()).body());
    }

    public ServiceFuture<JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), serviceCallback);
    }

    public Observable<JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map((Func1)new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>(){

            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return (JobExecutionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobExecutionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>(){

            public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobExecutionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobExecutionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobExecutionInner>(){}.getType()).register(201, new TypeToken<JobExecutionInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobExecutionInner> listByAgentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobExecutionsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByAgentNextAsync(String nextPageLink, ServiceFuture<List<JobExecutionInner>> serviceFuture, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobExecutionsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByAgentNextAsync(String nextPageLink) {
        return this.listByAgentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAgentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobExecutionsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByAgentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAgentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobExecutionsInner.this.listByAgentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByAgentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobExecutionInner> listByJobNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobExecutionsInner.this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByJobNextAsync(String nextPageLink, ServiceFuture<List<JobExecutionInner>> serviceFuture, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobExecutionsInner.this.listByJobNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByJobNextAsync(String nextPageLink) {
        return this.listByJobNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByJobNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobExecutionsInner.this.listByJobNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByJobNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobExecutionsInner.this.listByJobNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobExecutionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByAgent"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/executions")
        public Observable<Response<ResponseBody>> listByAgent(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="createTimeMin") DateTime var5, @Query(value="createTimeMax") DateTime var6, @Query(value="endTimeMin") DateTime var7, @Query(value="endTimeMax") DateTime var8, @Query(value="isActive") Boolean var9, @Query(value="$skip") Integer var10, @Query(value="$top") Integer var11, @Query(value="api-version") String var12, @Header(value="accept-language") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions cancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/cancel")
        public Observable<Response<ResponseBody>> cancel(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobExecutionId") UUID var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions create"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/start")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions beginCreate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/start")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByJob"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions")
        public Observable<Response<ResponseBody>> listByJob(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="createTimeMin") DateTime var6, @Query(value="createTimeMax") DateTime var7, @Query(value="endTimeMin") DateTime var8, @Query(value="endTimeMax") DateTime var9, @Query(value="isActive") Boolean var10, @Query(value="$skip") Integer var11, @Query(value="$top") Integer var12, @Query(value="api-version") String var13, @Header(value="accept-language") String var14, @Header(value="User-Agent") String var15);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobExecutionId") UUID var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobExecutionId") UUID var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobExecutionId") UUID var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByAgentNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAgentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobExecutions listByJobNext"})
        @GET
        public Observable<Response<ResponseBody>> listByJobNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

