/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.ServerAzureADAdministratorInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServerAzureADAdministratorsInner
implements InnerSupportsDelete<ServerAzureADAdministratorInner> {
    private ServerAzureADAdministratorsService service;
    private SqlManagementClientImpl client;

    public ServerAzureADAdministratorsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerAzureADAdministratorsService)retrofit.create(ServerAzureADAdministratorsService.class);
        this.client = client;
    }

    public ServerAzureADAdministratorInner createOrUpdate(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties) {
        return (ServerAzureADAdministratorInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, properties).toBlocking().last()).body());
    }

    public ServiceFuture<ServerAzureADAdministratorInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties, ServiceCallback<ServerAzureADAdministratorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, properties), serviceCallback);
    }

    public Observable<ServerAzureADAdministratorInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, properties).map((Func1)new Func1<ServiceResponse<ServerAzureADAdministratorInner>, ServerAzureADAdministratorInner>(){

            public ServerAzureADAdministratorInner call(ServiceResponse<ServerAzureADAdministratorInner> response) {
                return (ServerAzureADAdministratorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerAzureADAdministratorInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is required and cannot be null.");
        }
        Validator.validate((Object)((Object)properties));
        String administratorName = "activeDirectory";
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, "activeDirectory", "2014-04-01", properties, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServerAzureADAdministratorInner>(){}.getType());
    }

    public ServerAzureADAdministratorInner beginCreateOrUpdate(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties) {
        return (ServerAzureADAdministratorInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, properties).toBlocking().single()).body());
    }

    public ServiceFuture<ServerAzureADAdministratorInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties, ServiceCallback<ServerAzureADAdministratorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, properties), serviceCallback);
    }

    public Observable<ServerAzureADAdministratorInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, properties).map((Func1)new Func1<ServiceResponse<ServerAzureADAdministratorInner>, ServerAzureADAdministratorInner>(){

            public ServerAzureADAdministratorInner call(ServiceResponse<ServerAzureADAdministratorInner> response) {
                return (ServerAzureADAdministratorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerAzureADAdministratorInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerAzureADAdministratorInner properties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is required and cannot be null.");
        }
        Validator.validate((Object)((Object)properties));
        String administratorName = "activeDirectory";
        String apiVersion = "2014-04-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, "activeDirectory", "2014-04-01", properties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerAzureADAdministratorInner>>>(){

            public Observable<ServiceResponse<ServerAzureADAdministratorInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerAzureADAdministratorsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerAzureADAdministratorInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerAzureADAdministratorInner>(){}.getType()).register(201, new TypeToken<ServerAzureADAdministratorInner>(){}.getType()).register(202, new TypeToken<ServerAzureADAdministratorInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerAzureADAdministratorInner delete(String resourceGroupName, String serverName) {
        return (ServerAzureADAdministratorInner)((Object)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().last()).body());
    }

    public ServiceFuture<ServerAzureADAdministratorInner> deleteAsync(String resourceGroupName, String serverName, ServiceCallback<ServerAzureADAdministratorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerAzureADAdministratorInner> deleteAsync(String resourceGroupName, String serverName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerAzureADAdministratorInner>, ServerAzureADAdministratorInner>(){

            public ServerAzureADAdministratorInner call(ServiceResponse<ServerAzureADAdministratorInner> response) {
                return (ServerAzureADAdministratorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerAzureADAdministratorInner>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String administratorName = "activeDirectory";
        String apiVersion = "2014-04-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, serverName, "activeDirectory", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<ServerAzureADAdministratorInner>(){}.getType());
    }

    public ServerAzureADAdministratorInner beginDelete(String resourceGroupName, String serverName) {
        return (ServerAzureADAdministratorInner)((Object)((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body());
    }

    public ServiceFuture<ServerAzureADAdministratorInner> beginDeleteAsync(String resourceGroupName, String serverName, ServiceCallback<ServerAzureADAdministratorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerAzureADAdministratorInner> beginDeleteAsync(String resourceGroupName, String serverName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerAzureADAdministratorInner>, ServerAzureADAdministratorInner>(){

            public ServerAzureADAdministratorInner call(ServiceResponse<ServerAzureADAdministratorInner> response) {
                return (ServerAzureADAdministratorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerAzureADAdministratorInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String administratorName = "activeDirectory";
        String apiVersion = "2014-04-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, serverName, "activeDirectory", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerAzureADAdministratorInner>>>(){

            public Observable<ServiceResponse<ServerAzureADAdministratorInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerAzureADAdministratorsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerAzureADAdministratorInner> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerAzureADAdministratorInner>(){}.getType()).register(202, new TypeToken<ServerAzureADAdministratorInner>(){}.getType()).register(204, new TypeToken<ServerAzureADAdministratorInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerAzureADAdministratorInner get(String resourceGroupName, String serverName) {
        return (ServerAzureADAdministratorInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body());
    }

    public ServiceFuture<ServerAzureADAdministratorInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<ServerAzureADAdministratorInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerAzureADAdministratorInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerAzureADAdministratorInner>, ServerAzureADAdministratorInner>(){

            public ServerAzureADAdministratorInner call(ServiceResponse<ServerAzureADAdministratorInner> response) {
                return (ServerAzureADAdministratorInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerAzureADAdministratorInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String administratorName = "activeDirectory";
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, "activeDirectory", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerAzureADAdministratorInner>>>(){

            public Observable<ServiceResponse<ServerAzureADAdministratorInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerAzureADAdministratorsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerAzureADAdministratorInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerAzureADAdministratorInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<ServerAzureADAdministratorInner> listByServer(String resourceGroupName, String serverName) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ServerAzureADAdministratorInner>> listByServerAsync(String resourceGroupName, String serverName, ServiceCallback<List<ServerAzureADAdministratorInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<List<ServerAzureADAdministratorInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<List<ServerAzureADAdministratorInner>>, List<ServerAzureADAdministratorInner>>(){

            public List<ServerAzureADAdministratorInner> call(ServiceResponse<List<ServerAzureADAdministratorInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ServerAzureADAdministratorInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ServerAzureADAdministratorInner>>>>(){

            public Observable<ServiceResponse<List<ServerAzureADAdministratorInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerAzureADAdministratorsInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServerAzureADAdministratorInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServerAzureADAdministratorInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerAzureADAdministratorsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAzureADAdministrators createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="administratorName") String var4, @Query(value="api-version") String var5, @Body ServerAzureADAdministratorInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAzureADAdministrators beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="administratorName") String var4, @Query(value="api-version") String var5, @Body ServerAzureADAdministratorInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAzureADAdministrators delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="administratorName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAzureADAdministrators beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="administratorName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAzureADAdministrators get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="administratorName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAzureADAdministrators listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

